/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;

public class SRM_Quaternion_Params {
    public double e0 = 1.0;
    public double e1 = 0.0;
    public double e2 = 0.0;
    public double e3 = 0.0;

    public SRM_Quaternion_Params() {
    }

    public SRM_Quaternion_Params(double e0, double e1, double e2, double e3) {
        this.e0 = e0;
        this.e1 = e1;
        this.e2 = e2;
        this.e3 = e3;
    }

    public SRM_Quaternion_Params(SRM_Quaternion_Params params) {
        this.e0 = params.e0;
        this.e1 = params.e1;
        this.e2 = params.e2;
        this.e3 = params.e3;
    }

    public static final boolean isEqual(SRM_Quaternion_Params a, SRM_Quaternion_Params b, double tolerance) {
        if (Const.areEqualAngles(a.e0, 0.0, tolerance) && Const.areEqualAngles(b.e0, 0.0, tolerance)) {
            return true;
        }
        double[] params1_vec = new double[]{a.e1, a.e2, a.e3};
        double[] params2_vec = new double[]{b.e1, b.e2, b.e3};
        if (Const.areEqualAngles(a.e0, b.e0, tolerance) && Const.isEqual(params1_vec, params2_vec, tolerance)) {
            return true;
        }
        if (Const.areEqualAngles(a.e0, -b.e0, tolerance)) {
            params2_vec[0] = -params2_vec[0];
            params2_vec[1] = -params2_vec[1];
            params2_vec[2] = -params2_vec[2];
            if (Const.isEqual(params1_vec, params2_vec, tolerance)) {
                return true;
            }
        }
        return false;
    }

    public boolean valid() {
        return Const.isEqual(Const.square(this.e0) + Const.square(this.e1) + Const.square(this.e2) + Const.square(this.e3), 1.0, 1.0E-6);
    }

    public String toString() {
        return "[ " + this.e0 + ", " + this.e1 + ", " + this.e2 + ", " + this.e3 + " ]";
    }
}

