/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.CdetConv;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_TM_Params;
import SRM.SRF_TransverseMercator;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFSM_Japan_Rectangular_Plane_CS_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class TmConv
extends Conversions {
    private ToCdetConst _toCdetConst = null;
    private TmValidConst _tmValidConst = null;

    protected TmConv() {
        super(SRM_SRFT_Code.SRFTCOD_TRANSVERSE_MERCATOR, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new TmConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            src[0] = src[0] - ((SRF_TransverseMercator)srcSrf).get_false_easting();
            src[1] = src[1] - ((SRF_TransverseMercator)srcSrf).get_false_northing();
            if (this._tmValidConst == null) {
                this._tmValidConst = new TmValidConst(this.getOrmData(), ((SRF_TransverseMercator)srcSrf).getSRFParameters());
            }
            retValid = CoordCheck.forTransverseMercator_native(this._tmValidConst._m, this._tmValidConst._bl, this._tmValidConst._x_threshold, this._tmValidConst._y_threshold, src);
            this.toCdet(srcSrf, destSrf, src, dest);
            switch (srcSrf.getSRFSetCode()) {
                case SRFSCOD_ALABAMA_SPCS: {
                    retValid = CoordCheck.forALSP_cd(this.getOrmData(), ((SRF_TransverseMercator)srcSrf).getSRFParameters(), dest);
                    break;
                }
                case SRFSCOD_JAPAN_RECTANGULAR_PLANE_CS: {
                    retValid = CoordCheck.forJapan_cd(this.getOrmData(), (SRM_SRFSM_Japan_Rectangular_Plane_CS_Code)srcSrf.getSRFSetMemberCode(), ((SRF_TransverseMercator)srcSrf).getSRFParameters(), dest);
                    break;
                }
                case SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR: {
                    retValid = CoordCheck.forUTM_cd(this.getOrmData(), ((SRF_TransverseMercator)srcSrf).getSRFParameters(), (SRM_SRFSM_UTM_Code)srcSrf.getSRFSetMemberCode(), dest);
                    break;
                }
                default: {
                    retValid = CoordCheck.forTransverseMercator_cd(this.getOrmData(), ((SRF_TransverseMercator)srcSrf).getSRFParameters(), dest);
                    break;
                }
            }
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double ZERO_POINT_THREE_DEGREES = 0.005235987755982989;
        double ZERO_POINT_SEVEN_FIVE_DEGREES = 0.013089969389957472;
        double TWO_POINT_ZERO_DEGREES = Math.PI / 90;
        double TWO_POINT_SEVEN_DEGREES = 0.0471238898038469;
        double SIX_POINT_ZERO_DEGREES = 0.10471975511965978;
        double con_lon6 = 0.16666666666666666;
        double con_lon120 = 0.008333333333333333;
        double con_lon5040 = 1.984126984126984E-4;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst == null) {
            this._toCdetConst = new ToCdetConst(e_constants, ((SRF_TransverseMercator)srcSrf).getSRFParameters());
        }
        double source_x = source_generic_coordinate[0] * this._toCdetConst.CScale_inv;
        double source_y = source_generic_coordinate[1] * this._toCdetConst.CScale_inv;
        double source_z = source_generic_coordinate[2];
        double mu = (this._toCdetConst.smz + source_y) * this._toCdetConst.conap_inv;
        if (e_constants.Eps != 0.0) {
            double phi1 = Const.footPoint(e_constants, this._toCdetConst.arclength_spec, this._toCdetConst.footpoint_spec, mu);
            double sin_phi1 = Math.sin(phi1);
            double cos_phi1 = Math.cos(phi1);
            double sec_phi1 = 1.0 / cos_phi1;
            double sin_phi1_squared = Const.square(sin_phi1);
            double tan_phi1 = sin_phi1 * sec_phi1;
            double tan_phi1_squared = Const.square(tan_phi1);
            double omessp = 1.0 - Const.square(e_constants.Eps * sin_phi1);
            double eta_sub1_squared = e_constants.Epps2 * Const.square(cos_phi1);
            double Rn1_inv = Double.NaN;
            double phi = Double.NaN;
            double lambda = Double.NaN;
            Rn1_inv = Const.computeRnInv(sin_phi1_squared, e_constants);
            double zeta = source_x * Rn1_inv;
            double zeta_squared = Const.square(zeta);
            double lon_range = Math.abs(zeta * sec_phi1);
            if (lon_range < 0.005235987755982989) {
                phi = phi1 - tan_phi1 * omessp * zeta_squared * this._toCdetConst.con_lat2;
            } else {
                double b4 = 5.0 + Const.triple(tan_phi1_squared) + eta_sub1_squared * (1.0 - 4.0 * eta_sub1_squared - 9.0 * tan_phi1_squared);
                if (lon_range < Math.PI / 90) {
                    phi = phi1 - tan_phi1 * omessp * (zeta_squared * (this._toCdetConst.con_lat2 - zeta_squared * this._toCdetConst.con_lat24 * b4));
                } else {
                    double b6 = 61.0 + tan_phi1_squared * (90.0 + 45.0 * tan_phi1_squared) + eta_sub1_squared * (46.0 + tan_phi1_squared * (-252.0 - 90.0 * tan_phi1_squared));
                    if (lon_range < 0.10471975511965978) {
                        phi = phi1 - tan_phi1 * omessp * (zeta_squared * (this._toCdetConst.con_lat2 + zeta_squared * (-this._toCdetConst.con_lat24 * b4 + zeta_squared * this._toCdetConst.con_lat720 * b6)));
                    } else {
                        double b8 = 1385.0 + tan_phi1_squared * (3633.0 + tan_phi1_squared * (4095.0 + 1574.0 * tan_phi1_squared));
                        phi = phi1 - tan_phi1 * omessp * zeta_squared * (this._toCdetConst.con_lat2 + zeta_squared * (-this._toCdetConst.con_lat24 * b4 + zeta_squared * (this._toCdetConst.con_lat720 * b6 - zeta_squared * this._toCdetConst.con_lat40320 * b8)));
                    }
                }
            }
            double b3 = 1.0 + Const.twoTimes(tan_phi1_squared) + eta_sub1_squared;
            if (lon_range < 0.013089969389957472) {
                lambda = this._toCdetConst.longitude_origin + zeta * (1.0 - b3 * 0.16666666666666666 * zeta_squared) * sec_phi1;
            } else {
                double b5 = 5.0 + tan_phi1_squared * (28.0 + 24.0 * tan_phi1_squared) + eta_sub1_squared * (6.0 + 8.0 * tan_phi1_squared);
                if (lon_range < 0.0471238898038469) {
                    lambda = this._toCdetConst.longitude_origin + zeta * (1.0 + zeta_squared * (-b3 * 0.16666666666666666 + b5 * 0.008333333333333333 * zeta_squared)) * sec_phi1;
                } else {
                    double b7 = 61.0 + 662.0 * tan_phi1_squared + 1320.0 * Const.square(tan_phi1_squared) + 720.0 * Const.cube(tan_phi1_squared);
                    lambda = this._toCdetConst.longitude_origin + zeta * (1.0 + zeta_squared * (-0.16666666666666666 * b3 + zeta_squared * (0.008333333333333333 * b5 - zeta_squared * b7 * 1.984126984126984E-4))) * sec_phi1;
                }
            }
            dest_generic_coordinate[1] = phi;
            dest_generic_coordinate[0] = lambda;
        } else {
            double B = 1.0 / (this._toCdetConst.CScale * e_constants.A);
            double D = source_generic_coordinate[1] * B + this._toCdetConst.latitude_origin;
            double xB = source_generic_coordinate[0] * B;
            double xB2 = xB * xB;
            dest_generic_coordinate[1] = Math.asin(Math.sin(D) * (1.0 + (-0.5 + (0.20833333333333334 - 0.08472222222222223 * xB2) * xB2) * xB2));
            dest_generic_coordinate[0] = this._toCdetConst.longitude_origin + Math.atan2(xB * (1.0 + xB2 * (0.16666666666666666 + xB2 * 0.008333333333333333 + xB2 * 1.984126984126984E-4)), Math.cos(D));
        }
        dest_generic_coordinate[2] = source_z;
    }

    private class ToCdetConst {
        double con_lat;
        double con_lat2;
        double con_lat24;
        double con_lat120;
        double con_lat720;
        double con_lat40320;
        double longitude_origin;
        double latitude_origin;
        double CScale;
        double CScale_inv;
        double conap;
        double conap_inv;
        double smz;
        Const.ArcLengthConst arclength_spec;
        Const.FootPointConst footpoint_spec;

        public ToCdetConst(OrmData e_constants, SRF_TM_Params tmParams) {
            this.longitude_origin = tmParams.origin_longitude;
            this.latitude_origin = tmParams.origin_latitude;
            this.CScale = tmParams.central_scale;
            this.CScale_inv = 1.0 / this.CScale;
            this.con_lat = 1.0 / (1.0 - e_constants.Eps2);
            this.con_lat2 = 0.5 * this.con_lat;
            this.con_lat24 = this.con_lat / 24.0;
            this.con_lat120 = this.con_lat / 120.0;
            this.con_lat720 = this.con_lat / 720.0;
            this.con_lat40320 = this.con_lat / 40320.0;
            if (e_constants.Eps != 0.0) {
                this.arclength_spec = new Const.ArcLengthConst(e_constants);
                this.smz = Const.exactArcLength(e_constants.A, e_constants.C, e_constants.Eps2, this.latitude_origin);
                this.conap = e_constants.A * (1.0 - e_constants.Eps2 * (0.25 + e_constants.Eps2 * (0.046875 + e_constants.Eps2 * (0.01953125 + 0.01068115234375 * e_constants.Eps2))));
                this.footpoint_spec = new Const.FootPointConst(e_constants, this.arclength_spec, this.CScale);
            } else {
                this.smz = e_constants.A * this.latitude_origin;
                this.conap = e_constants.A;
            }
            this.conap_inv = 1.0 / this.conap;
        }
    }

    private class TmValidConst {
        double _m;
        double _bl;
        double _x_threshold;
        double _y_threshold;

        public TmValidConst(OrmData e_constants, SRF_TM_Params params) throws SrmException {
            CdetConv tmpCdet = new CdetConv();
            tmpCdet.setOrmData(e_constants);
            double[] uln = new double[]{0.0, 0.0, 0.0};
            double[] uls = new double[]{0.0, 0.0, 0.0};
            double[] eql = new double[]{0.0, 0.0, 0.0};
            double left_lon_val = Const.getLambdaStar(params.origin_longitude, -0.22689280275926285);
            double[] uln_cd = new double[]{left_lon_val, 1.570639247162217, 0.0};
            double[] uls_cd = new double[]{left_lon_val, 1.5706217938696971, 0.0};
            double[] eql_cd = new double[]{left_lon_val, 0.0, 0.0};
            tmpCdet.toTmer(params, uln_cd, uln);
            tmpCdet.toTmer(params, uls_cd, uls);
            tmpCdet.toTmer(params, eql_cd, eql);
            this._m = (uln[1] - uls[1]) / (uln[0] - uls[0]);
            this._bl = uln[1] - this._m * uln[0];
            this._y_threshold = this._m * eql[0] + this._bl;
            this._x_threshold = Math.abs(eql[0]);
        }
    }
}

