/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.io.supercsv;

import java.util.ArrayList;
import java.util.List;
import org.seedstack.io.spi.AbstractBaseTemplate;
import org.seedstack.io.supercsv.Column;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentStartsWith;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.NormalQuoteMode;
import org.supercsv.quote.QuoteMode;

public class SuperCsvTemplate
extends AbstractBaseTemplate {
    private final String name;
    private List<Column> columns = new ArrayList<Column>();
    private char quote = (char)34;
    private char separator = (char)59;
    private String endOfLine = "\n";
    private QuoteMode quoteMode = new NormalQuoteMode();
    private CsvEncoder encoder = new DefaultCsvEncoder();
    private CommentMatcher commentMatcher;
    private String charsetName = "UTF-8";
    private boolean showHeader;

    public SuperCsvTemplate(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "This template represents a CSV file. It gives you options to change general configuration, define format or provide custom validation.";
    }

    public CsvPreference getPreferences() {
        CsvPreference.Builder builder = new CsvPreference.Builder(this.quote, (int)this.separator, this.endOfLine).useQuoteMode(this.quoteMode).useEncoder(this.encoder);
        if (this.commentMatcher != null) {
            builder.skipComments(this.commentMatcher);
        }
        return builder.build();
    }

    public void setQuoteMode(QuoteMode quoteMode) {
        this.quoteMode = quoteMode;
    }

    public void setCsvEncoder(CsvEncoder encoder) {
        this.encoder = encoder;
    }

    public void skipComments(String startWith) {
        this.commentMatcher = new CommentStartsWith(startWith);
    }

    public void skipComments(CommentMatcher commentMatcher) {
        this.commentMatcher = commentMatcher;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void removeColumn(Column column) {
        this.columns.remove(column);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (Column column : this.columns) {
            headers.add(column.getName());
        }
        return headers;
    }

    public List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>();
        for (Column column : this.columns) {
            fields.add(column.getField());
        }
        return fields;
    }

    public List<CellProcessor> getWritingCellProcessors() {
        ArrayList<CellProcessor> cellProcessors = new ArrayList<CellProcessor>();
        for (Column column : this.columns) {
            cellProcessors.add(column.getWritingCellProcessor());
        }
        return cellProcessors;
    }

    public List<CellProcessor> getReadingCellProcessors() {
        ArrayList<CellProcessor> cellProcessors = new ArrayList<CellProcessor>();
        for (Column column : this.columns) {
            cellProcessors.add(column.getReadingCellProcessor());
        }
        return cellProcessors;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setEndOfLine(String endOfLine) {
        this.endOfLine = endOfLine;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean showHeader() {
        return this.showHeader;
    }

    public void showHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }
}

