/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.io.supercsv.internal;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.seedstack.io.spi.AbstractTemplateParser;
import org.seedstack.io.supercsv.SuperCsvTemplate;
import org.seedstack.io.supercsv.internal.SuperCsvErrorCode;
import org.seedstack.seed.SeedException;
import org.seedstack.shed.exception.ErrorCode;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanReader;

@Named(value="SuperCSV")
class SuperCsvParser<T>
extends AbstractTemplateParser<SuperCsvTemplate, T> {
    private static final String TEMPLATE = "template";

    SuperCsvParser() {
    }

    public List<T> parse(InputStream inputStream, Class<T> clazz) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream must not be null");
        Preconditions.checkNotNull(clazz, (Object)"clazz must not be null");
        CsvBeanReader beanReader = null;
        ArrayList<Object> beans = new ArrayList<Object>();
        try {
            Object bean;
            beanReader = new CsvBeanReader((Reader)new InputStreamReader(inputStream, ((SuperCsvTemplate)((Object)this.template)).getCharsetName()), ((SuperCsvTemplate)((Object)this.template)).getPreferences());
            if (((SuperCsvTemplate)((Object)this.template)).showHeader()) {
                beanReader.getHeader(true);
            }
            List<CellProcessor> confList = ((SuperCsvTemplate)((Object)this.template)).getReadingCellProcessors();
            CellProcessor[] processors = confList.toArray(new CellProcessor[confList.size()]);
            String[] fields = ((SuperCsvTemplate)((Object)this.template)).getFields().toArray(new String[((SuperCsvTemplate)((Object)this.template)).getFields().size()]);
            while ((bean = beanReader.read(clazz, fields, processors)) != null) {
                beans.add(bean);
            }
            this.closeQuietly((Closeable)beanReader);
        }
        catch (Exception e) {
            try {
                throw SeedException.wrap((Throwable)e, (ErrorCode)SuperCsvErrorCode.ERROR_DURING_SUPER_CSV_PARSING).put(TEMPLATE, (Object)((SuperCsvTemplate)((Object)this.template)).getName());
            }
            catch (Throwable throwable) {
                this.closeQuietly((Closeable)beanReader);
                throw throwable;
            }
        }
        return beans;
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

