/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.io.supercsv.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.seedstack.io.spi.AbstractTemplateRenderer;
import org.seedstack.io.supercsv.SuperCsvTemplate;
import org.seedstack.io.supercsv.internal.SuperCsvErrorCode;
import org.seedstack.seed.SeedException;
import org.seedstack.shed.exception.ErrorCode;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanWriter;

@Named(value="SuperCSV")
class SuperCsvRenderer
extends AbstractTemplateRenderer<SuperCsvTemplate> {
    private static final String SUPPORTED_MIME_TYPE = "application/csv";
    private static final String TEMPLATE = "template";

    SuperCsvRenderer() {
    }

    public void render(OutputStream outputStream, Object model) {
        this.render(outputStream, model, null, null);
    }

    public void render(OutputStream outputStream, Object model, String mimeType, Map<String, Object> parameters) {
        if (mimeType != null && !SUPPORTED_MIME_TYPE.equals(mimeType)) {
            throw new IllegalArgumentException(mimeType + " not supported. SuperCsvRenderer only supports application/csv MIME type");
        }
        CsvBeanWriter beanWriter = null;
        try {
            beanWriter = new CsvBeanWriter((Writer)new OutputStreamWriter(outputStream, ((SuperCsvTemplate)((Object)this.template)).getCharsetName()), ((SuperCsvTemplate)((Object)this.template)).getPreferences());
            List<CellProcessor> confList = ((SuperCsvTemplate)((Object)this.template)).getWritingCellProcessors();
            CellProcessor[] processors = confList.toArray(new CellProcessor[0]);
            String[] fields = ((SuperCsvTemplate)((Object)this.template)).getFields().toArray(new String[0]);
            if (((SuperCsvTemplate)((Object)this.template)).showHeader()) {
                beanWriter.writeHeader(((SuperCsvTemplate)((Object)this.template)).getHeaders().toArray(new String[0]));
            }
            if (model instanceof Collection) {
                Collection col = (Collection)model;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    beanWriter.write(it.next(), fields, processors);
                }
            } else {
                beanWriter.write(model, fields, processors);
            }
            this.closeQuietly((Closeable)beanWriter);
        }
        catch (Exception e) {
            try {
                throw SeedException.wrap((Throwable)e, (ErrorCode)SuperCsvErrorCode.ERROR_DURING_SUPER_CSV_RENDERING).put(TEMPLATE, (Object)((SuperCsvTemplate)((Object)this.template)).getName());
            }
            catch (Throwable throwable) {
                this.closeQuietly((Closeable)beanWriter);
                throw throwable;
            }
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

