/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.io.supercsv.internal;

import com.google.common.base.Strings;
import java.net.URL;
import java.util.Properties;
import org.seedstack.io.spi.AbstractBaseStaticTemplateLoader;
import org.seedstack.io.supercsv.Column;
import org.seedstack.io.supercsv.SuperCsvTemplate;
import org.seedstack.io.supercsv.internal.SuperCsvErrorCode;
import org.seedstack.seed.SeedException;
import org.seedstack.shed.exception.ErrorCode;
import org.supercsv.cellprocessor.FmtBool;
import org.supercsv.cellprocessor.FmtDate;
import org.supercsv.cellprocessor.FmtNumber;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.UniqueHashCode;
import org.supercsv.cellprocessor.ift.CellProcessor;

class SuperCsvStaticTemplateLoader
extends AbstractBaseStaticTemplateLoader<SuperCsvTemplate> {
    private static final String NULLABLE = ".nullable";
    private static final String UNIQUE = ".unique";
    private static final String TRUE = "true";
    private static final String TYPE = ".type";
    private static final String FORMAT = ".format";
    private static final String INTEGER = "integer";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String NUMBER = "number";
    private static final String DOUBLE = "double";
    private static final String BIG_DECIMAL = "bigDecimal";
    private static final String BOOLEAN = "boolean";
    private static final String DATE = "date";
    private static final String S_S = "\\s*,\\s*";
    private static final String BIG_BECIMAL = "bigBecimal";
    private static final String FALSE = "false";
    private static final String CHARSET_NAME = "charsetName";
    private static final String QUOTE = "quote";
    private static final String SEPARATOR = "separator";
    private static final String END_OF_LINE = "endOfLine";
    private static final String SHOW_HEADER = "showHeader";
    private static final String SUPER_CSV = "SuperCSV";
    private static final String NAME = ".name";
    private static final String COLUMNS = "columns";
    private static final String TEMPLATE = "template";
    private static final String URL = "url";

    SuperCsvStaticTemplateLoader() {
    }

    public String templatePathRegex() {
        return "(.+)\\.csv\\.properties";
    }

    public SuperCsvTemplate load(String name) {
        URL url = (URL)this.templateURLs.get(name);
        if (url != null) {
            String[] columns;
            Properties properties = new Properties();
            try {
                properties.load(url.openStream());
            }
            catch (Exception e) {
                throw SeedException.wrap((Throwable)e, (ErrorCode)SuperCsvErrorCode.ERROR_LOADING_SUPER_CSV_TEMPLATE).put(URL, (Object)url.toExternalForm()).put(TEMPLATE, (Object)name);
            }
            SuperCsvTemplate superCsvTemplate = new SuperCsvTemplate(url.getFile());
            this.checkGeneralConfig(superCsvTemplate, properties);
            String columnList = properties.getProperty(COLUMNS);
            if (Strings.isNullOrEmpty((String)columnList)) {
                throw new IllegalArgumentException("The columns property must be initialized in template " + url.getFile());
            }
            String[] stringArray = columns = columnList.trim().split(S_S);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String column;
                String columnName = properties.getProperty((column = stringArray[i]) + NAME);
                superCsvTemplate.addColumn(new Column(column, columnName != null ? columnName : column, this.getWritingProcessor(column, properties), this.getReadingProcessor(column, properties)));
            }
            return superCsvTemplate;
        }
        return null;
    }

    public String templateRenderer() {
        return SUPER_CSV;
    }

    public String templateParser() {
        return SUPER_CSV;
    }

    private void checkGeneralConfig(SuperCsvTemplate template, Properties properties) {
        String charsetName = properties.getProperty(CHARSET_NAME);
        String quote = properties.getProperty(QUOTE);
        String separator = properties.getProperty(SEPARATOR);
        String endOfLine = properties.getProperty(END_OF_LINE);
        String showHeader = properties.getProperty(SHOW_HEADER);
        if (!Strings.isNullOrEmpty((String)quote)) {
            template.setQuote(quote.charAt(0));
        }
        if (!Strings.isNullOrEmpty((String)separator)) {
            template.setSeparator(separator.charAt(0));
        }
        if (!Strings.isNullOrEmpty((String)endOfLine)) {
            template.setEndOfLine(endOfLine);
        }
        if (!Strings.isNullOrEmpty((String)charsetName)) {
            template.setCharsetName(charsetName);
        }
        if (!Strings.isNullOrEmpty((String)showHeader) && FALSE.equals(showHeader)) {
            template.showHeader(false);
        } else {
            template.showHeader(true);
        }
    }

    private CellProcessor getWritingProcessor(String column, Properties properties) {
        String nullable = properties.getProperty(column + NULLABLE);
        String unique = properties.getProperty(column + UNIQUE);
        return this.checkNullable(nullable, this.checkUnique(unique, this.checkWritingType(column, properties, null)));
    }

    private CellProcessor getReadingProcessor(String column, Properties properties) {
        String nullable = properties.getProperty(column + NULLABLE);
        String unique = properties.getProperty(column + UNIQUE);
        return this.checkNullable(nullable, this.checkUnique(unique, this.checkReadingType(column, properties, null)));
    }

    private CellProcessor checkNullable(String nullable, CellProcessor cellProcessor) {
        Object result = Strings.isNullOrEmpty((String)nullable) || TRUE.equalsIgnoreCase(nullable) ? (cellProcessor != null ? new Optional(cellProcessor) : new Optional()) : (cellProcessor != null ? new NotNull(cellProcessor) : new NotNull());
        return result;
    }

    private CellProcessor checkUnique(String unique, CellProcessor cellProcessor) {
        CellProcessor result = cellProcessor;
        if (TRUE.equals(unique)) {
            result = cellProcessor != null ? new UniqueHashCode(cellProcessor) : new UniqueHashCode();
        }
        return result;
    }

    private CellProcessor checkWritingType(String column, Properties properties, CellProcessor cellProcessor) {
        String type = properties.getProperty(column + TYPE);
        String format = properties.getProperty(column + FORMAT);
        CellProcessor result = cellProcessor;
        if (Strings.isNullOrEmpty((String)format)) {
            return cellProcessor;
        }
        if (DATE.equalsIgnoreCase(type)) {
            result = new FmtDate(format);
        } else if (INTEGER.equalsIgnoreCase(type) || INT.equalsIgnoreCase(type) || DOUBLE.equalsIgnoreCase(type) || LONG.equalsIgnoreCase(type) || BIG_DECIMAL.equalsIgnoreCase(type) || NUMBER.equalsIgnoreCase(type)) {
            result = new FmtNumber(format);
        } else if (BOOLEAN.equalsIgnoreCase(type)) {
            String[] yesNo = format.trim().split(S_S);
            result = new FmtBool(yesNo[0], yesNo[1]);
        }
        return result;
    }

    private CellProcessor checkReadingType(String column, Properties properties, CellProcessor cellProcessor) {
        String type = properties.getProperty(column + TYPE);
        String format = properties.getProperty(column + FORMAT);
        CellProcessor result = cellProcessor;
        if (!Strings.isNullOrEmpty((String)format) && DATE.equalsIgnoreCase(type)) {
            result = new ParseDate(format);
        } else if (NUMBER.equalsIgnoreCase(type)) {
            result = new ParseDouble();
        } else if (INT.equalsIgnoreCase(type) || INTEGER.equalsIgnoreCase(type)) {
            result = new ParseInt();
        } else if (DOUBLE.equalsIgnoreCase(type)) {
            result = new ParseDouble();
        } else if (LONG.equalsIgnoreCase(type)) {
            result = new ParseLong();
        } else if (BIG_BECIMAL.equalsIgnoreCase(type)) {
            result = new ParseBigDecimal();
        } else if (!Strings.isNullOrEmpty((String)format) && BOOLEAN.equalsIgnoreCase(type)) {
            String[] yesNo = format.trim().split(S_S);
            result = new ParseBool(yesNo[0], yesNo[1]);
        }
        return result;
    }
}

