/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.seedstack.coffig.Config;

@Config(value="application")
public class ApplicationConfig {
    @NotNull
    private Set<String> basePackages = new HashSet<String>();
    @NotNull
    @Size(min=1)
    private String id;
    @NotNull
    @Size(min=1)
    private String name = this.id = UUID.randomUUID().toString();
    @NotNull
    @Size(min=1)
    private String version = "1.0.0";
    private File storage;
    private boolean packageScanWarning = true;
    private boolean printBanner = true;
    private ColorOutput colorOutput = ColorOutput.AUTODETECT;

    public String getId() {
        return this.id;
    }

    public ApplicationConfig setId(String id) {
        if (this.id.equals(this.name)) {
            this.name = id;
        }
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ApplicationConfig setVersion(String version) {
        this.version = version;
        return this;
    }

    public File getStorage() {
        return this.storage;
    }

    public ApplicationConfig setStorage(File storage) {
        this.storage = storage;
        return this;
    }

    public boolean isStorageEnabled() {
        return this.storage != null;
    }

    public Set<String> getBasePackages() {
        return Collections.unmodifiableSet(this.basePackages);
    }

    public ApplicationConfig addBasePackage(String basePackage) {
        this.basePackages.add(basePackage);
        return this;
    }

    public boolean isPackageScanWarning() {
        return this.packageScanWarning;
    }

    public ApplicationConfig setPackageScanWarning(boolean packageScanWarning) {
        this.packageScanWarning = packageScanWarning;
        return this;
    }

    public boolean isPrintBanner() {
        return this.printBanner;
    }

    public ApplicationConfig setPrintBanner(boolean printBanner) {
        this.printBanner = printBanner;
        return this;
    }

    public ColorOutput getColorOutput() {
        return this.colorOutput;
    }

    public ApplicationConfig setColorOutput(ColorOutput colorOutput) {
        this.colorOutput = colorOutput;
        return this;
    }

    public static enum ColorOutput {
        AUTODETECT,
        PASSTHROUGH,
        ENABLE,
        DISABLE;

    }
}

