/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.seedstack.coffig.Config;
import org.seedstack.coffig.SingleValue;
import org.seedstack.seed.validation.NotBlank;

@Config(value="logging")
public class LoggingConfig {
    @SingleValue
    @NotNull
    private Level level = Level.INFO;
    private Map<String, LoggerConfig> loggers = new HashMap<String, LoggerConfig>();
    private ConsoleConfig console = new ConsoleConfig(true);
    private FileConfig file = new FileConfig(false);

    public Level getLevel() {
        return this.level;
    }

    public LoggingConfig setLevel(Level level) {
        this.level = level;
        return this;
    }

    public Map<String, LoggerConfig> loggers() {
        return Collections.unmodifiableMap(this.loggers);
    }

    public LoggingConfig configureLogger(String loggerName, LoggerConfig loggerConfig) {
        this.loggers.put(loggerName, loggerConfig);
        return this;
    }

    public ConsoleConfig console() {
        return this.console;
    }

    public FileConfig file() {
        return this.file;
    }

    public static class LoggerConfig {
        @SingleValue
        private Level level = Level.INFO;
        private boolean additive = true;

        public Level getLevel() {
            return this.level;
        }

        public LoggerConfig setLevel(Level level) {
            this.level = level;
            return this;
        }

        public boolean isAdditive() {
            return this.additive;
        }

        public LoggerConfig setAdditive(boolean additive) {
            this.additive = additive;
            return this;
        }
    }

    @Config(value="file")
    public static class FileConfig
    extends OutputConfig {
        public static final String DEFAULT_LOG_FILE = "application.log";
        @NotBlank
        private String path = "application.log";
        private String maxSize;

        public FileConfig() {
        }

        public FileConfig(boolean enabled) {
            super(enabled);
        }

        public String getPath() {
            return this.path;
        }

        public FileConfig setPath(String path) {
            this.path = path;
            return this;
        }

        public String getMaxSize() {
            return this.maxSize;
        }

        public FileConfig setMaxSize(String maxSize) {
            this.maxSize = maxSize;
            return this;
        }
    }

    @Config(value="console")
    public static class ConsoleConfig
    extends OutputConfig {
        private Output output = Output.STDOUT;

        public ConsoleConfig() {
        }

        public ConsoleConfig(boolean enabled) {
            super(enabled);
        }

        public Output getOutput() {
            return this.output;
        }

        public ConsoleConfig setOutput(Output output) {
            this.output = output;
            return this;
        }

        public static enum Output {
            STDOUT,
            STDERR;

        }
    }

    public static abstract class OutputConfig {
        private boolean enabled;
        private String pattern;

        public OutputConfig() {
        }

        public OutputConfig(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public OutputConfig setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public String getPattern() {
            return this.pattern;
        }

        public OutputConfig setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

