/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.seedstack.seed.validation.NotBlank;

public class NotBlankValidator
implements ConstraintValidator<NotBlank, String> {
    public void initialize(NotBlank constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        int length = value.length();
        return this.indexOfNonWhitespace(value, length) < length;
    }

    private int indexOfNonWhitespace(String value, int length) {
        char ch;
        int left;
        for (left = 0; left < length && ((ch = value.charAt(left)) == ' ' || ch == '\t' || Character.isWhitespace(ch)); ++left) {
        }
        return left;
    }
}

