/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.encryption.AESEngineNoPadding;

public class ConcatenatingAESEngine
extends AESEngineNoPadding {
    private SecureRandom random = new SecureRandom();

    ConcatenatingAESEngine() {
        super((BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine())));
    }

    @Override
    public InputStream encryptStream(InputStream data, byte[] key) {
        return this.encryptStream(data, key, this.initializationVector());
    }

    @Override
    public InputStream encryptStream(InputStream data, byte[] key, byte[] iv) {
        return new SequenceInputStream(new ByteArrayInputStream(iv), super.encryptStream(data, key, iv));
    }

    @Override
    public byte[] encryptBytes(byte[] data, byte[] key) {
        return this.encryptBytes(data, key, this.initializationVector());
    }

    @Override
    public byte[] encryptBytes(byte[] data, byte[] key, byte[] iv) {
        return Arrays.concatenate((byte[])iv, (byte[])super.encryptBytes(data, key, iv));
    }

    private byte[] initializationVector() {
        byte[] iv = new byte[16];
        this.random.nextBytes(iv);
        return iv;
    }
}

