/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.pdmodel.graphics.color.PDJPXColorSpace;

public final class JPXFilter
extends Filter {
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        DecodeResult result = new DecodeResult(new COSDictionary());
        result.getParameters().addAll(parameters);
        BufferedImage image = this.readJPX(encoded, result);
        WritableRaster raster = image.getRaster();
        switch (raster.getDataBuffer().getDataType()) {
            case 0: {
                DataBufferByte byteBuffer = (DataBufferByte)raster.getDataBuffer();
                decoded.write(byteBuffer.getData());
                return result;
            }
            case 1: {
                DataBufferUShort wordBuffer = (DataBufferUShort)raster.getDataBuffer();
                for (short w : wordBuffer.getData()) {
                    decoded.write(w >> 8);
                    decoded.write(w);
                }
                return result;
            }
            case 3: {
                int[] ar = new int[raster.getNumBands()];
                for (int y = 0; y < image.getHeight(); ++y) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        raster.getPixel(x, y, ar);
                        for (int i = 0; i < ar.length; ++i) {
                            decoded.write(ar[i]);
                        }
                    }
                }
                return result;
            }
        }
        throw new IOException("Data type " + raster.getDataBuffer().getDataType() + " not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPX(InputStream input, DecodeResult result) throws IOException {
        ImageReader reader = JPXFilter.findImageReader("JPEG2000", "Java Advanced Imaging (JAI) Image I/O Tools are not installed");
        MemoryCacheImageInputStream iis = null;
        try {
            BufferedImage image;
            iis = new MemoryCacheImageInputStream(input);
            reader.setInput(iis, true, true);
            try {
                image = reader.read(0);
            }
            catch (Exception e) {
                throw new IOException("Could not read JPEG 2000 (JPX) image", e);
            }
            COSDictionary parameters = result.getParameters();
            int bpc = image.getColorModel().getPixelSize() / image.getRaster().getNumBands();
            parameters.setInt(COSName.BITS_PER_COMPONENT, bpc);
            if (!parameters.getBoolean(COSName.IMAGE_MASK, false)) {
                parameters.removeItem(COSName.DECODE);
            }
            parameters.setInt(COSName.WIDTH, reader.getWidth(0));
            parameters.setInt(COSName.HEIGHT, reader.getHeight(0));
            if (!parameters.containsKey(COSName.COLORSPACE)) {
                if (image.getSampleModel() instanceof MultiPixelPackedSampleModel && image.getColorModel().getPixelSize() == 1 && image.getRaster().getNumBands() == 1 && image.getColorModel() instanceof IndexColorModel) {
                    result.setColorSpace(new PDJPXColorSpace(ColorSpace.getInstance(1003)));
                } else {
                    result.setColorSpace(new PDJPXColorSpace(image.getColorModel().getColorSpace()));
                }
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
            reader.dispose();
        }
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) {
        throw new UnsupportedOperationException("JPX encoding not implemented");
    }
}

