/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDNameTreeNode<T extends COSObjectable>
implements COSObjectable {
    private static final Logger LOG = LoggerFactory.getLogger(PDNameTreeNode.class);
    private final COSDictionary node;
    private PDNameTreeNode<T> parent;

    protected PDNameTreeNode() {
        this.node = new COSDictionary();
    }

    protected PDNameTreeNode(COSDictionary dict) {
        this.node = dict;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.node;
    }

    public PDNameTreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(PDNameTreeNode<T> parentNode) {
        this.parent = parentNode;
        this.calculateLimits();
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public List<PDNameTreeNode<T>> getKids() {
        COSArray kids;
        if (Objects.nonNull(this.node) && (kids = (COSArray)this.node.getDictionaryObject(COSName.KIDS)) != null) {
            ArrayList<PDNameTreeNode<T>> pdObjects = new ArrayList<PDNameTreeNode<T>>();
            for (int i = 0; i < kids.size(); ++i) {
                pdObjects.add(this.createChildNode((COSDictionary)kids.getObject(i)));
            }
            return new COSArrayList<PDNameTreeNode<T>>(pdObjects, kids);
        }
        return null;
    }

    public void setKids(List<? extends PDNameTreeNode<T>> kids) {
        if (kids != null && kids.size() > 0) {
            for (PDNameTreeNode<T> kidsNode : kids) {
                kidsNode.setParent(this);
            }
            this.node.setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(kids));
            if (this.isRootNode()) {
                this.node.removeItem(COSName.NAMES);
            }
        } else {
            this.node.removeItem(COSName.KIDS);
            this.node.removeItem(COSName.LIMITS);
        }
        this.calculateLimits();
    }

    private void calculateLimits() {
        if (this.isRootNode()) {
            this.node.removeItem(COSName.LIMITS);
        } else {
            List<PDNameTreeNode<T>> kids = this.getKids();
            if (kids != null && kids.size() > 0) {
                PDNameTreeNode<T> firstKid = kids.get(0);
                PDNameTreeNode<T> lastKid = kids.get(kids.size() - 1);
                String lowerLimit = firstKid.getLowerLimit();
                this.setLowerLimit(lowerLimit);
                String upperLimit = lastKid.getUpperLimit();
                this.setUpperLimit(upperLimit);
            } else {
                try {
                    Map<String, T> names = this.getNames();
                    if (names != null && names.size() > 0) {
                        Set<String> strings = names.keySet();
                        String[] keys = strings.toArray(new String[strings.size()]);
                        String lowerLimit = keys[0];
                        this.setLowerLimit(lowerLimit);
                        String upperLimit = keys[keys.length - 1];
                        this.setUpperLimit(upperLimit);
                    } else {
                        this.node.removeItem(COSName.LIMITS);
                    }
                }
                catch (IOException exception) {
                    this.node.removeItem(COSName.LIMITS);
                    LOG.error("Error while calculating the Limits of a PageNameTreeNode:", (Throwable)exception);
                }
            }
        }
    }

    public T getValue(String name) {
        block6: {
            try {
                Map<String, T> names = this.getNames();
                if (Objects.isNull(names)) {
                    List<PDNameTreeNode<T>> kids = this.getKids();
                    if (kids != null) {
                        for (PDNameTreeNode<T> childNode : kids) {
                            T value;
                            if (!super.couldContain(name) || !Objects.nonNull(value = childNode.getValue(name))) continue;
                            return value;
                        }
                    } else {
                        LOG.warn("NameTreeNode does not have \"names\" nor \"kids\" objects.");
                    }
                    break block6;
                }
                return (T)((COSObjectable)names.get(name));
            }
            catch (IOException e) {
                LOG.warn("NameTreeNode couldn't get the names map", (Throwable)e);
            }
        }
        return null;
    }

    private boolean couldContain(String name) {
        if (Objects.isNull(this.node) || Objects.isNull(this.getLowerLimit()) || Objects.isNull(this.getUpperLimit())) {
            LOG.warn("Missing required name tree node Limits array");
            return false;
        }
        return this.getLowerLimit().compareTo(name) <= 0 && this.getUpperLimit().compareTo(name) >= 0;
    }

    public Map<String, T> getNames() throws IOException {
        COSArray namesArray = (COSArray)this.node.getDictionaryObject(COSName.NAMES);
        if (namesArray != null) {
            LinkedHashMap<String, T> names = new LinkedHashMap<String, T>();
            for (int i = 0; i < namesArray.size(); i += 2) {
                COSString key = (COSString)namesArray.getObject(i);
                COSBase cosValue = namesArray.getObject(i + 1);
                names.put(key.getString(), this.convertCOSToPD(cosValue));
            }
            return Collections.unmodifiableMap(names);
        }
        return null;
    }

    protected abstract T convertCOSToPD(COSBase var1) throws IOException;

    protected abstract PDNameTreeNode<T> createChildNode(COSDictionary var1);

    public void setNames(Map<String, T> names) {
        if (names == null) {
            this.node.setItem(COSName.NAMES, (COSObjectable)null);
            this.node.setItem(COSName.LIMITS, (COSObjectable)null);
        } else {
            COSArray array = new COSArray();
            ArrayList<String> keys = new ArrayList<String>(names.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                array.add(COSString.parseLiteral(key));
                array.add((COSObjectable)names.get(key));
            }
            this.node.setItem(COSName.NAMES, (COSBase)array);
            this.calculateLimits();
        }
    }

    public String getUpperLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getString(1);
        }
        return retval;
    }

    private void setUpperLimit(String upper) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add((COSBase)null);
            arr.add((COSBase)null);
            this.node.setItem(COSName.LIMITS, (COSBase)arr);
        }
        arr.setString(1, upper);
    }

    public String getLowerLimit() {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (Objects.nonNull(arr)) {
            return arr.getString(0);
        }
        return null;
    }

    private void setLowerLimit(String lower) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add((COSBase)null);
            arr.add((COSBase)null);
            this.node.setItem(COSName.LIMITS, (COSBase)arr);
        }
        arr.setString(0, lower);
    }
}

