/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.contentstream.operator.text;

import java.util.List;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveText
extends OperatorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MoveText.class);

    @Override
    public void process(Operator operator, List<COSBase> arguments) throws MissingOperandException {
        if (arguments.size() < 2) {
            throw new MissingOperandException(operator, arguments);
        }
        Matrix textLineMatrix = this.getContext().getTextLineMatrix();
        if (textLineMatrix == null) {
            LOG.warn("TextLineMatrix is null, " + this.getName() + " operator will be ignored");
            return;
        }
        COSBase base0 = arguments.get(0);
        COSBase base1 = arguments.get(1);
        if (!(base0 instanceof COSNumber)) {
            return;
        }
        COSNumber x = (COSNumber)base0;
        if (!(base1 instanceof COSNumber)) {
            return;
        }
        COSNumber y = (COSNumber)base1;
        Matrix matrix = new Matrix(1.0f, 0.0f, 0.0f, 1.0f, x.floatValue(), y.floatValue());
        textLineMatrix.concatenate(matrix);
        this.getContext().setTextMatrix(textLineMatrix.clone());
    }

    @Override
    public String getName() {
        return "Td";
    }
}

