/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSVisitor;

public final class COSInteger
extends COSNumber {
    private static final Map<Long, COSInteger> CACHE = new ConcurrentHashMap<Long, COSInteger>();
    public static final COSInteger ZERO = COSInteger.get(0L);
    public static final COSInteger ONE = COSInteger.get(1L);
    public static final COSInteger TWO = COSInteger.get(2L);
    public static final COSInteger THREE = COSInteger.get(3L);
    private final long value;

    public static COSInteger get(long val) {
        COSInteger value = CACHE.get(val);
        if (value == null) {
            COSInteger newVal = new COSInteger(val);
            value = CACHE.putIfAbsent(val, newVal);
            if (value == null) {
                value = newVal;
            }
        }
        return value;
    }

    public COSInteger(long value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        return o instanceof COSInteger && ((COSInteger)o).intValue() == this.intValue();
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

