/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.regex.Pattern;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;

public abstract class COSNumber
extends COSBase {
    private static final Pattern NUMBER = Pattern.compile("(E|e|\\+|\\-|\\.|\\d)+");

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int intValue();

    public abstract long longValue();

    private static boolean isNumber(String s) {
        try {
            return NUMBER.matcher(s).matches();
        }
        catch (StackOverflowError soe) {
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (NumberFormatException nfex) {
                return false;
            }
        }
    }

    public static COSNumber get(String number) throws IOException {
        RequireUtils.requireNotNullArg((Object)number, (String)"Number cannot be null");
        RequireUtils.requireArg((boolean)COSNumber.isNumber(number), (String)("Invalid number " + number));
        if (number.length() == 1) {
            char digit = number.charAt(0);
            if ('0' <= digit && digit <= '9') {
                return COSInteger.get((long)digit - 48L);
            }
            return COSInteger.ZERO;
        }
        if (COSNumber.isFloat(number)) {
            return new COSFloat(number);
        }
        try {
            return COSInteger.get(Long.parseLong(number));
        }
        catch (NumberFormatException e) {
            return COSInteger.ZERO;
        }
    }

    private static boolean isFloat(String number) {
        int length = number.length();
        for (int i = 0; i < length; ++i) {
            char digit = number.charAt(i);
            if (digit != '.' && digit != 'e') continue;
            return true;
        }
        return false;
    }

    @Override
    public void idIfAbsent(IndirectCOSObjectIdentifier id) {
    }
}

