/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.io.InputStream;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.encryption.AESEncryptionAlgorithmEngine;
import org.sejda.sambox.encryption.ConcatenatingAESEngine;
import org.sejda.sambox.encryption.GeneralEncryptionAlgorithm;

class Algorithm1A
implements GeneralEncryptionAlgorithm {
    private AESEncryptionAlgorithmEngine engine = new ConcatenatingAESEngine();
    private final byte[] key;

    Algorithm1A(byte[] key, AESEncryptionAlgorithmEngine engine) {
        this(key);
        RequireUtils.requireNotNullArg((Object)engine, (String)"Enecryption engine cannot be null");
        this.engine = engine;
    }

    Algorithm1A(byte[] key) {
        RequireUtils.requireNotNullArg((Object)key, (String)"Encryption key cannot be null");
        RequireUtils.requireArg((key.length == 32 ? 1 : 0) != 0, (String)"General encryption algorithm 1.A requires a 32 bytes key");
        this.key = key;
    }

    @Override
    public void visit(COSString value) {
        if (value.encryptable()) {
            value.setValue(this.engine.encryptBytes(value.getBytes(), this.key));
        }
    }

    @Override
    public void visit(COSStream value) {
        if (value.encryptable()) {
            value.setEncryptor(i -> this.engine.encryptStream((InputStream)i, this.key));
        }
    }

    @Override
    public void setCurrentCOSObjectKey(COSObjectKey key) {
    }

    public String toString() {
        return "Algorithm1A with engine " + this.engine;
    }
}

