/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.util.Objects;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.encryption.AESEngineNoPadding;
import org.sejda.sambox.encryption.Algorithm2AHash;
import org.sejda.sambox.encryption.EncryptUtils;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.encryption.PasswordAlgorithm;
import org.sejda.sambox.encryption.StandardSecurityHandlerRevision;

class Algorithm8
implements PasswordAlgorithm {
    private final byte[] userValidationSalt;
    private final byte[] userKeySalt;
    private final Algorithm2AHash hashAlgo;
    private final AESEngineNoPadding engine = AESEngineNoPadding.cbc();

    Algorithm8(Algorithm2AHash hashAlgo) {
        this(hashAlgo, EncryptUtils.rnd(8), EncryptUtils.rnd(8));
    }

    Algorithm8(Algorithm2AHash hashAlgo, byte[] userValidationSalt, byte[] userKeySalt) {
        Objects.requireNonNull(hashAlgo);
        this.hashAlgo = hashAlgo;
        this.userValidationSalt = userValidationSalt;
        this.userKeySalt = userKeySalt;
    }

    @Override
    public byte[] computePassword(EncryptionContext context) {
        context.security.encryption.revision.requireAtLeast(StandardSecurityHandlerRevision.R5, "Algorithm 8 requires a security handler of revision 5 or greater");
        byte[] userPassword = context.security.getUserPasswordUTF();
        return Arrays.concatenate((byte[])this.hashAlgo.computeHash(Arrays.concatenate((byte[])userPassword, (byte[])this.userValidationSalt), userPassword), (byte[])this.userValidationSalt, (byte[])this.userKeySalt);
    }

    public byte[] computeUE(EncryptionContext context) {
        context.security.encryption.revision.requireAtLeast(StandardSecurityHandlerRevision.R5, "Algorithm 8 requires a security handler of revision 5 or greater");
        byte[] userPassword = context.security.getUserPasswordUTF();
        byte[] key = this.hashAlgo.computeHash(Arrays.concatenate((byte[])userPassword, (byte[])this.userKeySalt), userPassword);
        return Arrays.copyOf((byte[])this.engine.encryptBytes(context.key(), key), (int)32);
    }
}

