/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RunLengthDecodeFilter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RunLengthDecodeFilter.class);
    private static final int RUN_LENGTH_EOD = 128;

    RunLengthDecodeFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        int dupAmount;
        byte[] buffer = new byte[128];
        while ((dupAmount = encoded.read()) != -1 && dupAmount != 128) {
            if (dupAmount <= 127) {
                int compressedRead;
                for (int amountToCopy = dupAmount + 1; amountToCopy > 0 && (compressedRead = encoded.read(buffer, 0, amountToCopy)) != -1; amountToCopy -= compressedRead) {
                    decoded.write(buffer, 0, compressedRead);
                }
                continue;
            }
            int dupByte = encoded.read();
            if (dupByte == -1) break;
            for (int i = 0; i < 257 - dupAmount; ++i) {
                decoded.write(dupByte);
            }
        }
        return new DecodeResult(parameters);
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) {
        LOG.warn("RunLengthDecodeFilter.encode is not implemented yet, skipping this stream.");
    }
}

