/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.fixup.processor;

import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.fixup.processor.AbstractProcessor;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;

public class AcroFormDefaultsProcessor
extends AbstractProcessor {
    public AcroFormDefaultsProcessor(PDDocument document) {
        super(document);
    }

    @Override
    public void process() {
        PDAcroForm acroForm = this.document.getDocumentCatalog().getAcroForm(null);
        if (acroForm != null) {
            this.verifyOrCreateDefaults(acroForm);
        }
    }

    private void verifyOrCreateDefaults(PDAcroForm acroForm) {
        COSDictionary fontDict;
        PDResources defaultResources;
        String adobeDefaultAppearanceString = "/Helv 0 Tf 0 g ";
        if (acroForm.getDefaultAppearance().length() == 0) {
            acroForm.setDefaultAppearance("/Helv 0 Tf 0 g ");
        }
        if ((defaultResources = acroForm.getDefaultResources()) == null) {
            defaultResources = new PDResources();
            acroForm.setDefaultResources(defaultResources);
        }
        if ((fontDict = defaultResources.getCOSObject().getDictionaryObject(COSName.FONT, COSDictionary.class)) == null) {
            fontDict = new COSDictionary();
            defaultResources.getCOSObject().setItem(COSName.FONT, (COSBase)fontDict);
        }
        if (!fontDict.containsKey(COSName.HELV)) {
            defaultResources.put(COSName.HELV, PDType1Font.HELVETICA);
        }
        if (!fontDict.containsKey(COSName.ZA_DB)) {
            defaultResources.put(COSName.ZA_DB, PDType1Font.ZAPF_DINGBATS);
        }
    }
}

