/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDSignatureField
extends PDTerminalField {
    private static final Logger LOG = LoggerFactory.getLogger(PDSignatureField.class);

    public PDSignatureField(PDAcroForm acroForm) {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.SIG);
        PDAnnotationWidget firstWidget = this.getWidgets().get(0);
        firstWidget.setLocked(true);
        firstWidget.setPrinted(true);
    }

    PDSignatureField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    @Override
    public String getValueAsString() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.V)).map(Object::toString).orElse("");
    }

    @Override
    void constructAppearances() {
        PDAnnotationWidget widget = this.getWidgets().get(0);
        if (widget != null) {
            if (widget.getRectangle() == null || widget.getRectangle().getHeight() == 0.0f && widget.getRectangle().getWidth() == 0.0f || widget.isNoView() || widget.isHidden()) {
                return;
            }
            LOG.warn("Signature field appearance not implemented");
        }
    }

    @Override
    public void setValue(String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Signature fields don't support setting the value as String - use setValue(PDSignature value) instead");
    }
}

