/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.sejda.commons.FastByteArrayOutputStream;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void close(Closeable closeable) throws IOException {
        if (Objects.nonNull(closeable)) {
            closeable.close();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        try {
            IOUtils.close(closeable);
        }
        catch (IOException ioe) {
            Optional.ofNullable(consumer).ifPresentOrElse(c -> c.accept(ioe), () -> LOG.warn("An error occurred while closing a Closeable resource", (Throwable)ioe));
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        try (FastByteArrayOutputStream output = new FastByteArrayOutputStream();){
            input.transferTo(output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        RequireUtils.requireNotNullArg(input, "Cannot copy a null input");
        RequireUtils.requireNotNullArg(output, "Cannot copy to a null output");
        input.transferTo(output);
    }
}

