/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.commons.util;

import java.io.File;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sejda.commons.util.StringUtils;

public class NumericalSortFilenameComparator
implements Comparator<File> {
    private static final Pattern DIGITS_PATTERN = Pattern.compile("^(\\d*)(.*)(\\d*)$");
    private static final Comparator<String> BIG_INT_COMPARATOR = (a, b) -> {
        BigInteger bigA = NumericalSortFilenameComparator.toBigInteger(a);
        BigInteger bigB = NumericalSortFilenameComparator.toBigInteger(b);
        if (Objects.nonNull(bigA) && Objects.nonNull(bigB)) {
            return bigA.compareTo(bigB);
        }
        return 0;
    };
    private final Comparator<Matcher> digitsPatternMatcherComparator = Comparator.comparing(m -> m.group(1), BIG_INT_COMPARATOR).thenComparing(m -> m.group(2), this::stringCompare).thenComparing(m -> m.group(3), BIG_INT_COMPARATOR);
    private final Comparator<String> fallback;

    public NumericalSortFilenameComparator(Comparator<String> fallback) {
        this.fallback = Optional.ofNullable(fallback).orElse(Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
    }

    public NumericalSortFilenameComparator() {
        this(null);
    }

    @Override
    public int compare(File a, File b) {
        Matcher m1 = Optional.ofNullable(a).map(NumericalSortFilenameComparator::basename).map(DIGITS_PATTERN::matcher).filter(Matcher::matches).orElse(null);
        Matcher m2 = Optional.ofNullable(b).map(NumericalSortFilenameComparator::basename).map(DIGITS_PATTERN::matcher).filter(Matcher::matches).orElse(null);
        if (Objects.nonNull(m1) && Objects.nonNull(m2) && StringUtils.isEmpty(m1.group(1)) ^ StringUtils.isEmpty(m2.group(1))) {
            return this.fallback.compare(NumericalSortFilenameComparator.name(a), NumericalSortFilenameComparator.name(b));
        }
        int retVal = Comparator.nullsLast(this.digitsPatternMatcherComparator).compare(m1, m2);
        if (retVal == 0) {
            return this.fallback.compare(NumericalSortFilenameComparator.name(a), NumericalSortFilenameComparator.name(b));
        }
        return retVal;
    }

    private int stringCompare(String a, String b) {
        if (StringUtils.isNotEmpty(a) && StringUtils.isNotEmpty(b)) {
            return this.fallback.compare(a, b);
        }
        return 0;
    }

    private static BigInteger toBigInteger(String value) {
        if (StringUtils.isNotEmpty(value)) {
            return new BigInteger(value);
        }
        return null;
    }

    private static String basename(File file) {
        if (Objects.nonNull(file)) {
            String filename = file.getName();
            int index = filename.lastIndexOf(46);
            if (index > 0) {
                return filename.substring(0, index);
            }
            if (StringUtils.isNotEmpty(filename)) {
                return filename;
            }
        }
        return null;
    }

    private static String name(File file) {
        return Optional.ofNullable(file).map(File::getName).orElse(null);
    }
}

