/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.pdf.page.PageRange;

public class BasePageRangeAdapter {
    private static final String SEPARATOR = "-";
    private boolean acceptAllString = false;
    private PageRange pageRange;

    public BasePageRangeAdapter(String rawString, boolean acceptAllString) {
        this.acceptAllString = acceptAllString;
        try {
            this.pageRange = this.doParsePageRange(rawString);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Unparsable page range '" + rawString + "'. " + e.getMessage(), e);
        }
        if (this.pageRange.getStart() > this.pageRange.getEnd()) {
            throw new ConversionException("Invalid page range '" + rawString + "', ends before starting");
        }
    }

    public PageRange getPageRange() {
        return this.pageRange;
    }

    private PageRange doParsePageRange(String rawString) {
        if (this.acceptAllString && AdapterUtils.isAllPages(rawString)) {
            return new PageRange(1);
        }
        String[] tokens = AdapterUtils.splitAndTrim(rawString, SEPARATOR);
        if (tokens.length == 1) {
            if (rawString.contains(SEPARATOR)) {
                return new PageRange(this.parsePageNumber(tokens[0]));
            }
            return new PageRange(this.parsePageNumber(tokens[0]), this.parsePageNumber(tokens[0]));
        }
        if (tokens.length == 2) {
            int token0 = this.parsePageNumber(tokens[0]);
            int token1 = this.parsePageNumber(tokens[1]);
            return new PageRange(token0, token1);
        }
        throw new ConversionException("Ambiguous definition. Use following formats: [<page>] or [<page1>-<page2>] or [<page1>-]");
    }

    private int parsePageNumber(String s) {
        return AdapterUtils.parseInt(StringUtils.trim((String)s), "page number");
    }

    public static final class PageRangeWithAllAdapter
    extends BasePageRangeAdapter {
        public PageRangeWithAllAdapter(String rawString) {
            super(rawString, true);
        }
    }

    public static final class PageRangeAdapter
    extends BasePageRangeAdapter {
        public PageRangeAdapter(String rawString) {
            super(rawString, false);
        }
    }
}

