/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.icepdf;

import java.awt.image.RenderedImage;
import java.io.File;
import org.icepdf.core.pobjects.Document;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.icepdf.BasePdfToImageTask;
import org.sejda.impl.icepdf.component.DefaultPdfSourceOpener;
import org.sejda.impl.icepdf.component.PdfToBufferedImageProvider;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.image.AbstractPdfToSingleImageParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfToSingleImageTask<T extends AbstractPdfToSingleImageParameters>
extends BasePdfToImageTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToSingleImageTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<Document> sourceOpener = new DefaultPdfSourceOpener();
    private Document pdfDocument = null;

    @Override
    public void before(T parameters) throws TaskExecutionException {
        super.before(parameters);
        if (!this.getWriter().supportMultiImage()) {
            throw new TaskExecutionException("Selected ImageWriter doesn't support multiple images in the same file");
        }
        this.outputWriter = OutputWriters.newSingleOutputWriter((boolean)parameters.isOverwrite());
    }

    public void execute(T parameters) throws TaskException {
        File tmpFile = IOUtils.createTemporaryBuffer();
        LOG.debug("Created output temporary buffer {} ", (Object)tmpFile);
        this.pdfDocument = (Document)parameters.getSource().open(this.sourceOpener);
        int numberOfPages = this.pdfDocument.getNumberOfPages();
        LOG.trace("Found {} pages", (Object)numberOfPages);
        this.getWriter().openWriteDestination(tmpFile, parameters);
        for (int zeroBasedPageNumber = 0; zeroBasedPageNumber < this.pdfDocument.getNumberOfPages(); ++zeroBasedPageNumber) {
            LOG.trace("Writing page {}", (Object)(zeroBasedPageNumber + 1));
            this.getWriter().write((RenderedImage)PdfToBufferedImageProvider.toBufferedImage(this.pdfDocument, zeroBasedPageNumber, parameters), parameters);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.getNotifiableTaskMetadata()).stepsCompleted(zeroBasedPageNumber + 1).outOf(numberOfPages);
        }
        this.getWriter().closeDestination();
        this.outputWriter.setOutput(FileOutput.file((File)tmpFile).name(parameters.getOutputName()));
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Document converted to {} and saved to {}", (Object)parameters.getOutputImageType(), (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        super.after();
        if (this.pdfDocument != null) {
            this.pdfDocument.dispose();
        }
    }
}

