/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.model;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.image.TiffCompressionType;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractXmlGraphicsImageWriterAdapter<T extends AbstractPdfToImageParameters>
implements ImageWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXmlGraphicsImageWriterAdapter.class);
    private static final Map<TiffCompressionType, String> TIFF_COMPRESSION_TYPE_CACHE;
    private OutputStream outputDestination;

    AbstractXmlGraphicsImageWriterAdapter() {
    }

    @Override
    public void openWriteDestination(File destination, T params) throws TaskIOException {
        try {
            this.openWriteDestination((OutputStream)new SeekableOutputStream(new RandomAccessFile(destination, "rw")), params);
        }
        catch (FileNotFoundException e) {
            throw new TaskIOException("Unable to find destination file.", (Throwable)e);
        }
    }

    public void setOutputStream(OutputStream destination) {
        this.outputDestination = destination;
    }

    @Override
    public void closeDestination() throws TaskIOException {
        try {
            ComponentsUtility.nullSafeClose((Closeable)this.outputDestination);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    ImageWriterParams newImageWriterParams(T params, TiffCompressionType compressionType) {
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setResolution(params.getResolutionInDpi());
        String compression = TIFF_COMPRESSION_TYPE_CACHE.get(compressionType);
        if (StringUtils.isNotBlank((CharSequence)compression)) {
            imageWriterParams.setCompressionMethod(compression);
        } else {
            LOG.warn("{} compression type is currently not supported by XML Graphics.", (Object)compressionType);
        }
        return imageWriterParams;
    }

    OutputStream getOutputDestination() {
        return this.outputDestination;
    }

    @Override
    public void close() throws IOException {
        ComponentsUtility.nullSafeClose((Closeable)this.getOutputDestination());
    }

    static {
        HashMap<TiffCompressionType, String> compressionTypesCache = new HashMap<TiffCompressionType, String>();
        compressionTypesCache.put(TiffCompressionType.PACKBITS, "PackBits");
        compressionTypesCache.put(TiffCompressionType.NONE, "NONE");
        compressionTypesCache.put(TiffCompressionType.JPEG_TTN2, "JPEG");
        compressionTypesCache.put(TiffCompressionType.DEFLATE, "Deflate");
        TIFF_COMPRESSION_TYPE_CACHE = Collections.unmodifiableMap(compressionTypesCache);
    }
}

