/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.model;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.internal.TIFFImageWriter;
import org.sejda.core.writer.model.AbstractXmlGraphicsImageWriterAdapter;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.PdfToMultipleTiffParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XmlGraphicsMultipleOutputTiffImageWriterAdapter
extends AbstractXmlGraphicsImageWriterAdapter<PdfToMultipleTiffParameters> {
    private ImageWriter adaptedWriter = new TIFFImageWriter();

    private XmlGraphicsMultipleOutputTiffImageWriterAdapter() {
    }

    @Override
    public void openWriteDestination(OutputStream destination, PdfToMultipleTiffParameters params) {
        this.setOutputStream(destination);
    }

    @Override
    public void write(RenderedImage image, PdfToMultipleTiffParameters params) throws TaskIOException {
        if (this.getOutputDestination() == null) {
            throw new TaskIOException("Cannot call write before opening the write destination");
        }
        ImageWriterParams imageWriterParams = this.newImageWriterParams(params, params.getCompressionType());
        try {
            this.adaptedWriter.writeImage(image, this.getOutputDestination(), imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    @Override
    public boolean supportMultiImage() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.adaptedWriter = null;
        super.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class XmlGraphicsMultipleOutputTiffImageWriterAdapterBuilder
    implements ImageWriter.ImageWriterBuilder<PdfToMultipleTiffParameters> {
        XmlGraphicsMultipleOutputTiffImageWriterAdapterBuilder() {
        }

        public XmlGraphicsMultipleOutputTiffImageWriterAdapter build() {
            return new XmlGraphicsMultipleOutputTiffImageWriterAdapter();
        }
    }
}

