/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.imageio;

import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.sejda.common.ComponentsUtility;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.image.TiffCompressionType;
import org.sejda.model.parameter.image.PdfToImageParameters;

abstract class AbstractImageWriter<T extends PdfToImageParameters>
implements org.sejda.core.writer.model.ImageWriter<T> {
    static final Map<TiffCompressionType, String> TIFF_COMPRESSION_TYPE_CACHE;
    private ImageOutputStream out;
    protected final ImageWriter writer;

    AbstractImageWriter(String format) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
        if (Objects.isNull(writers) || !writers.hasNext()) {
            throw new IllegalArgumentException(String.format("Unable to find an ImageWriter for the format %s", format));
        }
        this.writer = writers.next();
    }

    abstract ImageWriteParam newImageWriterParams(T var1);

    public IIOMetadata newImageMetadata(RenderedImage image, T params, ImageWriteParam writerParams) {
        return null;
    }

    @Override
    public void openDestination(File file, T params) throws TaskIOException {
        try {
            this.out = ImageIO.createImageOutputStream(file);
            TaskIOException.require((boolean)Objects.nonNull(this.out), (String)"Unable to create image output stream");
            this.writer.setOutput(this.getOutput());
        }
        catch (IOException e) {
            throw new TaskIOException("Unable to create output stream.", (Throwable)e);
        }
    }

    ImageOutputStream getOutput() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.writer)) {
            this.writer.dispose();
        }
    }

    @Override
    public void closeDestination() throws TaskIOException {
        try {
            ComponentsUtility.nullSafeClose((Closeable)this.getOutput());
        }
        catch (IOException e) {
            throw new TaskIOException("Unable to close destination", (Throwable)e);
        }
    }

    static {
        HashMap<TiffCompressionType, String> compressionTypesCache = new HashMap<TiffCompressionType, String>();
        compressionTypesCache.put(TiffCompressionType.PACKBITS, "PackBits");
        compressionTypesCache.put(TiffCompressionType.NONE, "None");
        compressionTypesCache.put(TiffCompressionType.JPEG_TTN2, "JPEG");
        compressionTypesCache.put(TiffCompressionType.DEFLATE, "Deflate");
        compressionTypesCache.put(TiffCompressionType.LZW, "LZW");
        compressionTypesCache.put(TiffCompressionType.ZLIB, "ZLib");
        compressionTypesCache.put(TiffCompressionType.CCITT_GROUP_3_1D, "CCITT RLE");
        compressionTypesCache.put(TiffCompressionType.CCITT_GROUP_3_2D, "CCITT T.4");
        compressionTypesCache.put(TiffCompressionType.CCITT_GROUP_4, "CCITT T.6");
        TIFF_COMPRESSION_TYPE_CACHE = Collections.unmodifiableMap(compressionTypesCache);
    }
}

