/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.imageio;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import org.sejda.core.writer.imageio.AbstractImageWriter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.PdfToImageParameters;

abstract class SingleImageWriter<T extends PdfToImageParameters>
extends AbstractImageWriter<T> {
    SingleImageWriter(String imageFormat) {
        super(imageFormat);
    }

    @Override
    public void write(RenderedImage image, T params) throws TaskIOException {
        TaskIOException.require((boolean)Objects.nonNull(this.getOutput()), (String)"Cannot call write before opening the write destination");
        ImageWriteParam imageWriterParams = this.newImageWriterParams(params);
        try {
            this.writer.write(null, new IIOImage(image, null, this.newImageMetadata(image, params, imageWriterParams)), imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    @Override
    public boolean supportMultiImage() {
        return false;
    }
}

