/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.IOUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ImageOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(ImageOptimizer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File optimize(BufferedImage bufferedImage, float quality, int dpi, int width, int height, boolean gray) throws IOException {
        long start = System.currentTimeMillis();
        File outputFile = File.createTempFile("pdfimage", ".jpeg");
        outputFile.deleteOnExit();
        try {
            boolean isShirinking;
            int relevantDelta = 20;
            boolean isResizeRelevant = Math.abs(bufferedImage.getWidth() - width) > relevantDelta && Math.abs(bufferedImage.getHeight() - height) > relevantDelta;
            boolean bl = isShirinking = bufferedImage.getHeight() > height || bufferedImage.getWidth() > width;
            if (isResizeRelevant && isShirinking) {
                LOG.debug("Resizing image from {}x{} to {}x{}", new Object[]{bufferedImage.getWidth(), bufferedImage.getHeight(), width, height});
                bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.BALANCED, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
            }
            BufferedImage newImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), gray ? 10 : 1);
            Graphics2D g2d = newImage.createGraphics();
            g2d.drawImage(bufferedImage, 0, 0, Color.WHITE, null);
            g2d.dispose();
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(outputFile);
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(quality);
            IIOMetadata imageMetaData = null;
            try {
                imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(newImage), jpegParams);
                Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
                Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
                jfif.setAttribute("Xdensity", Integer.toString(dpi));
                jfif.setAttribute("Ydensity", Integer.toString(dpi));
                jfif.setAttribute("resUnits", "1");
                imageMetaData.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            }
            catch (Exception e) {
                LOG.warn("Failed to set DPI for image, metadata manipulation failed", (Throwable)e);
            }
            try {
                imageWriter.write(null, new IIOImage(newImage, null, imageMetaData), jpegParams);
            }
            finally {
                IOUtils.closeQuietly((Closeable)ios);
                imageWriter.dispose();
            }
            File file = outputFile;
            return file;
        }
        finally {
            bufferedImage.flush();
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 500L) {
                LOG.trace("Optimizing image took " + elapsed + "ms");
            }
        }
    }
}

