/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    private static final Optional<Consumer<ByteBuffer>> UNMAPPER = Optional.ofNullable(AccessController.doPrivileged(IOUtils::unmapper));

    private IOUtils() {
    }

    public static void unmap(ByteBuffer buf) {
        try {
            UNMAPPER.ifPresent(u -> u.accept(buf));
        }
        catch (Exception e) {
            LOG.error("Unable to unmap ByteBuffer.", (Throwable)e);
        }
    }

    private static Consumer<ByteBuffer> unmapper() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return IOUtils.newBufferCleaner(ByteBuffer.class, unmapper.bindTo(theUnsafe));
        }
        catch (SecurityException se) {
            LOG.error("Unmapping is not supported because of missing permissions. Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\")  and ReflectPermission(\"suppressAccessChecks\")", (Throwable)se);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            LOG.error("Unmapping is not supported.", (Throwable)e);
        }
        return null;
    }

    private static Consumer<ByteBuffer> newBufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
        assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), unmapper.type()));
        return buffer -> {
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("unmapping only works with direct buffers");
            }
            if (!unmappableBufferClass.isInstance(buffer)) {
                throw new IllegalArgumentException("buffer is not an instance of " + unmappableBufferClass.getName());
            }
            Throwable e = AccessController.doPrivileged(() -> {
                try {
                    unmapper.invokeExact((ByteBuffer)buffer);
                    return null;
                }
                catch (Throwable t) {
                    return t;
                }
            });
            if (Objects.nonNull(e)) {
                LOG.error("Unable to unmap the mapped buffer", e);
            }
        };
    }
}

