/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.label;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.pdf.label.PdfLabelNumberingStyle;

public final class PdfPageLabel {
    @NotNull
    private String labelPrefix;
    @NotNull
    private PdfLabelNumberingStyle numberingStyle;
    @Min(value=1L)
    private @Min(value=1L) int logicalPageNumber;

    private PdfPageLabel(String labelPrefix, PdfLabelNumberingStyle numberingStyle, int logicalPageNumber) {
        this.labelPrefix = labelPrefix;
        this.numberingStyle = numberingStyle;
        this.logicalPageNumber = logicalPageNumber;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public PdfLabelNumberingStyle getNumberingStyle() {
        return this.numberingStyle;
    }

    public int getLogicalPageNumber() {
        return this.logicalPageNumber;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.labelPrefix).append((Object)this.numberingStyle).append("logicalPageNumber", this.logicalPageNumber).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.labelPrefix).append((Object)this.numberingStyle).append(this.logicalPageNumber).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PdfPageLabel)) {
            return false;
        }
        PdfPageLabel pageLabel = (PdfPageLabel)other;
        return new EqualsBuilder().append((Object)this.labelPrefix, (Object)pageLabel.getLabelPrefix()).append((Object)this.numberingStyle, (Object)pageLabel.getNumberingStyle()).append(this.logicalPageNumber, pageLabel.getLogicalPageNumber()).isEquals();
    }

    public static PdfPageLabel newInstanceWithoutLabel(PdfLabelNumberingStyle numberingStyle, int logicalPageNumber) {
        return PdfPageLabel.newInstanceWithLabel("", numberingStyle, logicalPageNumber);
    }

    public static PdfPageLabel newInstanceWithLabel(String label, PdfLabelNumberingStyle numberingStyle, int logicalPageNumber) {
        RequireUtils.requireArg((logicalPageNumber > 0 ? 1 : 0) != 0, (String)"Input page number must be positive");
        RequireUtils.requireNotNullArg((Object)label, (String)"Input label cannot be null");
        RequireUtils.requireNotNullArg((Object)numberingStyle, (String)"Input numbering style cannot be null");
        return new PdfPageLabel(label, numberingStyle, logicalPageNumber);
    }
}

