/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.task;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.input.TaskSource;
import org.sejda.model.task.Task;

public class NotifiableTaskMetadata
implements Serializable {
    private static final long serialVersionUID = -6423865557633949211L;
    public static final NotifiableTaskMetadata NULL = new NullNotifiableTaskMetadata();
    private UUID taskIdentifier;
    private String qualifiedName;
    private List<File> taskOutput = new ArrayList<File>();
    private List<File> skippedOutput = new ArrayList<File>();
    private String currentSource;

    private NotifiableTaskMetadata() {
    }

    public NotifiableTaskMetadata(Task<?> task) {
        RequireUtils.requireNotNullArg(task, (String)"No task given, unable to create notifiable metadata.");
        this.taskIdentifier = UUID.randomUUID();
        this.qualifiedName = task.getClass().getName();
    }

    public UUID getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void addTaskOutput(File output) {
        if (Objects.nonNull(output)) {
            this.taskOutput.add(output);
        }
    }

    public void addSkippedOutput(File skipped) {
        if (Objects.nonNull(skipped)) {
            this.skippedOutput.add(skipped);
        }
    }

    public void setCurrentSource(TaskSource<?> source) {
        this.currentSource = source.getName();
    }

    public void clearCurrentSource() {
        this.currentSource = "";
    }

    public String getCurrentSource() {
        return this.currentSource;
    }

    public List<File> taskOutput() {
        return Collections.unmodifiableList(this.taskOutput);
    }

    public List<File> skippedOutput() {
        return Collections.unmodifiableList(this.skippedOutput);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.taskIdentifier).append((Object)this.qualifiedName).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotifiableTaskMetadata)) {
            return false;
        }
        NotifiableTaskMetadata meta = (NotifiableTaskMetadata)other;
        return new EqualsBuilder().append((Object)this.taskIdentifier, (Object)meta.taskIdentifier).append((Object)this.qualifiedName, (Object)meta.qualifiedName).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("taskIdentifier", (Object)this.taskIdentifier).append("qualifiedName", (Object)this.qualifiedName).toString();
    }

    private static class NullNotifiableTaskMetadata
    extends NotifiableTaskMetadata {
        private static final long serialVersionUID = 6788562820506828221L;

        private NullNotifiableTaskMetadata() {
        }

        @Override
        public UUID getTaskIdentifier() {
            return null;
        }

        @Override
        public String getQualifiedName() {
            return "";
        }
    }
}

