/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

public class SingleOutputExtensionsValidator
implements ConstraintValidator<SingleOutputAllowedExtensions, SingleOutputTaskParameters> {
    private String[] extensions;

    public void initialize(SingleOutputAllowedExtensions constraintAnnotation) {
        this.extensions = constraintAnnotation.extensions();
    }

    public boolean isValid(SingleOutputTaskParameters value, ConstraintValidatorContext context) {
        if (Objects.nonNull(value) && Objects.nonNull(value.getOutput()) && ArrayUtils.isNotEmpty((Object[])this.extensions)) {
            String fileName = value.getOutput().getDestination().getName();
            if (this.hasAllowedExtension(fileName)) {
                return true;
            }
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("The output '%s' is not one of the expected types: %s", fileName, ArrayUtils.toString((Object)this.extensions))).addPropertyNode("taskOutput").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean hasAllowedExtension(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        for (String current : this.extensions) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)current, (CharSequence)extension) || FilenameUtils.indexOfExtension((String)fileName) <= 0) continue;
            return true;
        }
        return false;
    }
}

