/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.AcroFormsMerger;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.CatalogPageLabelsMerger;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.FilenameFooterWriter;
import org.sejda.impl.sambox.component.OutlineMerger;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfRotator;
import org.sejda.impl.sambox.component.PdfScaler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.impl.sambox.component.TableOfContentsCreator;
import org.sejda.impl.sambox.component.image.ImagesToPdfDocumentConverter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.MergeInput;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.BaseMergeParameters;
import org.sejda.model.parameter.MergeParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.rotation.Rotation;
import org.sejda.model.scale.ScaleType;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.model.toc.ToCPolicy;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTask
extends BaseTask<MergeParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener;
    private int totalSteps;
    private PDDocumentHandler destinationDocument;
    private Queue<Closeable> toClose = new LinkedList<Closeable>();
    private OutlineMerger outlineMerger;
    private CatalogPageLabelsMerger catalogPageLabelsMerger;
    private AcroFormsMerger acroFormsMerger;
    private TableOfContentsCreator tocCreator;
    private FilenameFooterWriter footerWriter;
    private PDRectangle currentPageSize = PDRectangle.A4;
    private int pagesCounter = 0;
    private int inputsCounter = 0;
    private int firstInputNumberOfPages = 0;

    public void before(MergeParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getInputList().size();
        this.sourceOpener = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
        this.outlineMerger = new OutlineMerger(parameters.getOutlinePolicy());
    }

    public void execute(MergeParameters parameters) throws TaskException {
        int currentStep = 0;
        File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.setCompress(parameters.isCompress());
        this.acroFormsMerger = new AcroFormsMerger(parameters.getAcroFormPolicy(), this.destinationDocument.getUnderlyingPDDocument());
        this.tocCreator = new TableOfContentsCreator(parameters, this.destinationDocument.getUnderlyingPDDocument());
        this.footerWriter = new FilenameFooterWriter(parameters.isFilenameFooter(), this.destinationDocument.getUnderlyingPDDocument());
        this.catalogPageLabelsMerger = new CatalogPageLabelsMerger(parameters.getCatalogPageLabelsPolicy());
        ImagesToPdfDocumentConverter.convertImageMergeInputToPdf((BaseMergeParameters<MergeInput>)parameters, this.executionContext());
        for (PdfMergeInput input : parameters.getPdfInputList()) {
            ++this.inputsCounter;
            LOG.debug("Opening {}", (Object)input.getSource());
            PDDocumentHandler sourceDocumentHandler = (PDDocumentHandler)input.getSource().open(this.sourceOpener);
            this.toClose.add(sourceDocumentHandler);
            if (this.inputsCounter == 1) {
                this.firstInputNumberOfPages = sourceDocumentHandler.getNumberOfPages();
            }
            LOG.debug("Adding pages");
            LookupTable pagesLookup = new LookupTable();
            long relativePagesCounter = 0L;
            Set pagesToImport = input.getPages(sourceDocumentHandler.getNumberOfPages());
            for (Integer currentPage : pagesToImport) {
                this.executionContext().assertTaskNotCancelled();
                ++this.pagesCounter;
                ++relativePagesCounter;
                try {
                    PDPage page = sourceDocumentHandler.getPage(currentPage);
                    this.currentPageSize = page.getMediaBox().rotate(page.getRotation());
                    PDPage importedPage = this.destinationDocument.importPage(page);
                    pagesLookup.addLookupEntry((Object)page, (Object)importedPage);
                    Rotation rotation = parameters.getRotation(this.inputsCounter - 1);
                    if (rotation != Rotation.DEGREES_0) {
                        PdfRotator.rotate(importedPage, rotation);
                    }
                    String sourceBaseName = FilenameUtils.getBaseName((String)input.getSource().getName());
                    if (this.tocCreator.shouldGenerateToC() && relativePagesCounter == 1L && (!parameters.isFirstInputCoverTitle() || this.inputsCounter != 1)) {
                        this.tocCreator.pageSizeIfNotSet(this.currentPageSize);
                        if (ToCPolicy.DOC_TITLES == parameters.getTableOfContentsPolicy()) {
                            sourceBaseName = Optional.ofNullable(sourceDocumentHandler.getUnderlyingPDDocument().getDocumentInformation()).map(i -> i.getTitle()).filter(StringUtils::isNotBlank).orElse(sourceBaseName);
                        }
                        this.tocCreator.appendItem(sourceBaseName, this.pagesCounter, importedPage);
                    }
                    long currentPageNumber = (long)this.pagesCounter + this.tocCreator.tocNumberOfPages();
                    if (parameters.isFirstInputCoverTitle() && this.inputsCounter == 1) {
                        currentPageNumber = this.pagesCounter;
                    }
                    this.footerWriter.addFooter(importedPage, sourceBaseName, currentPageNumber);
                    LOG.trace("Added imported page");
                }
                catch (PageNotFoundException e) {
                    this.executionContext().assertTaskIsLenient((Exception)((Object)e));
                    ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be processed", currentPage), (Exception)((Object)e));
                }
            }
            relativePagesCounter = 0L;
            this.outlineMerger.updateOutline(sourceDocumentHandler.getUnderlyingPDDocument(), input.getSource().getName(), (LookupTable<PDPage>)pagesLookup);
            LookupTable<PDAnnotation> annotationsLookup = new AnnotationsDistiller(sourceDocumentHandler.getUnderlyingPDDocument()).retainRelevantAnnotations((LookupTable<PDPage>)pagesLookup);
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.acroFormsMerger.mergeForm(sourceDocumentHandler.getUnderlyingPDDocument().getDocumentCatalog().getAcroForm(), annotationsLookup);
            if (parameters.isBlankPageIfOdd()) {
                Optional.ofNullable(this.destinationDocument.addBlankPageIfOdd(this.currentPageSize)).ifPresent(p -> ++this.pagesCounter);
            }
            this.catalogPageLabelsMerger.add(sourceDocumentHandler.getUnderlyingPDDocument(), pagesToImport);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(this.totalSteps);
        }
        if (this.outlineMerger.hasOutline()) {
            LOG.debug("Adding generated outline");
            this.destinationDocument.setDocumentOutline(this.outlineMerger.getOutline());
        }
        Optional.ofNullable(this.acroFormsMerger.getForm()).filter(f -> !f.getFields().isEmpty()).ifPresent(f -> {
            LOG.debug("Adding generated AcroForm");
            this.destinationDocument.setDocumentAcroForm((PDAcroForm)f);
        });
        if (parameters.isNormalizePageSizes()) {
            LOG.debug("Normalizing page widths to match width of first page");
            new PdfScaler(ScaleType.PAGE).scalePages(this.destinationDocument.getUnderlyingPDDocument());
        }
        if (this.tocCreator.hasToc()) {
            LOG.debug("Adding generated ToC");
            int beforePageNumber = 0;
            if (parameters.isFirstInputCoverTitle()) {
                beforePageNumber = this.firstInputNumberOfPages;
            }
            this.tocCreator.addToC(beforePageNumber);
        }
        if (this.catalogPageLabelsMerger.hasPageLabels()) {
            LOG.debug("Adding merged /Catalog /PageLabels");
            this.destinationDocument.getUnderlyingPDDocument().getDocumentCatalog().setPageLabels(this.catalogPageLabelsMerger.getMergedPageLabels());
        }
        this.destinationDocument.savePDDocument(tmpFile);
        this.closeResources();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Input documents merged correctly and written to {}", (Object)parameters.getOutput());
    }

    private void closeResources() {
        Closeable current;
        while ((current = this.toClose.poll()) != null) {
            ComponentsUtility.nullSafeCloseQuietly((Closeable)current);
        }
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.destinationDocument);
    }

    public void after() {
        this.closeResources();
        this.outputWriter = null;
    }
}

