/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimization;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.impl.sambox.component.optimization.InUseFontDictionary;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDictionaryCleaner
implements Consumer<PDDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDictionaryCleaner.class);

    @Override
    public void accept(PDDocument p) {
        LOG.debug("Cleaning resource dictionaries from unused resources");
        this.clean(p.getPages().streamNodes());
    }

    public void clean(PDPage page) {
        this.clean(Stream.of(page.getCOSObject()));
    }

    private void clean(Stream<COSDictionary> nodes) {
        Set<COSDictionary> resources = nodes.map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull).collect(Collectors.toSet());
        this.cleanResources(resources);
        Set<COSDictionary> formsResources = resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull).flatMap(d -> d.getValues().stream()).filter(d -> d.getCOSObject() instanceof COSDictionary).map(d -> (COSDictionary)d.getCOSObject()).filter(d -> COSName.FORM.equals((Object)d.getCOSName(COSName.SUBTYPE))).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull).collect(Collectors.toSet());
        this.cleanResources(formsResources);
    }

    private void cleanResources(Set<COSDictionary> resources) {
        this.cleanXObject(resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull));
        this.cleanFonts(resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull));
    }

    private void cleanXObject(Stream<COSDictionary> xobjects) {
        xobjects.forEach(x -> {
            Set toRemove = x.entrySet().stream().filter(e -> !(((COSBase)e.getValue()).getCOSObject() instanceof ReadOnlyFilteredCOSStream)).filter(e -> ((COSBase)e.getValue()).getCOSObject() instanceof COSStream).map(e -> (COSName)e.getKey()).collect(Collectors.toSet());
            LOG.trace("Removing {} xobjects from {}", (Object)toRemove.size(), x);
            toRemove.stream().forEach(arg_0 -> ((COSDictionary)x).removeItem(arg_0));
        });
    }

    private void cleanFonts(Stream<COSDictionary> fonts) {
        fonts.forEach(f -> {
            Set toRemove = f.entrySet().stream().filter(e -> !(((COSBase)e.getValue()).getCOSObject() instanceof InUseFontDictionary)).map(e -> (COSName)e.getKey()).collect(Collectors.toSet());
            LOG.trace("Removing {} fonts from {}", (Object)toRemove.size(), f);
            toRemove.stream().forEach(arg_0 -> ((COSDictionary)f).removeItem(arg_0));
        });
    }
}

