/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileGray;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.sejda.impl.sambox.component.ExifHelper;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.Source;
import org.sejda.model.util.IOUtils;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.pdmodel.graphics.image.UnsupportedImageFormatException;
import org.sejda.sambox.pdmodel.graphics.image.UnsupportedTiffImageException;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.sejda.sambox.util.Matrix;
import org.sejda.sambox.util.filetypedetector.FileType;
import org.sejda.sambox.util.filetypedetector.FileTypeDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageImageWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PageImageWriter.class);
    private PDDocument document;

    public PageImageWriter(PDDocument document) {
        this.document = document;
    }

    public void append(PDPage page, PDImageXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.APPEND, gs, true, rotation);
    }

    public void append(PDPage page, PDFormXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.APPEND, gs, true, rotation);
    }

    public void prepend(PDPage page, PDImageXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.PREPEND, gs, false, rotation);
    }

    public void prepend(PDPage page, PDFormXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.PREPEND, gs, false, rotation);
    }

    private void write(PDPage page, PDXObject image, Point2D position, float width, float height, PDPageContentStream.AppendMode mode, PDExtendedGraphicsState gs, boolean resetContext, int rotation) throws TaskIOException {
        try (PDPageContentStream contentStream = new PDPageContentStream(this.document, page, mode, true, resetContext);){
            AffineTransform at = new AffineTransform(width, 0.0f, 0.0f, height, (float)position.getX(), (float)position.getY());
            if (rotation != 0) {
                at.rotate(Math.toRadians(rotation));
            }
            if (image instanceof PDFormXObject) {
                contentStream.drawImage((PDFormXObject)image, new Matrix(at), gs);
            } else {
                contentStream.drawImage((PDImageXObject)image, new Matrix(at), gs);
            }
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred writing image to the page.", (Throwable)e);
        }
    }

    public static PDImageXObject toPDXImageObject(Source<?> source) throws TaskIOException {
        try {
            return PageImageWriter.createFromSeekableSource(source.getSeekableSource(), source.getName());
        }
        catch (Exception e) {
            throw new TaskIOException("An error occurred creating PDImageXObject from file source: " + source.getName(), (Throwable)e);
        }
    }

    public static PDImageXObject createFromSeekableSource(SeekableSource original, String name) throws TaskIOException, IOException {
        SeekableSource source = original;
        Optional<SeekableSource> maybeConvertedFile = PageImageWriter.convertExifRotatedIf(source, name);
        if (maybeConvertedFile.isPresent()) {
            source = maybeConvertedFile.get();
        }
        if ((maybeConvertedFile = PageImageWriter.convertCMYKJpegIf(source, name)).isPresent()) {
            source = maybeConvertedFile.get();
        }
        if ((maybeConvertedFile = PageImageWriter.convertICCGrayPngIf(source, name)).isPresent()) {
            source = maybeConvertedFile.get();
        }
        try {
            return PDImageXObject.createFromSeekableSource((SeekableSource)source, (String)name);
        }
        catch (UnsupportedTiffImageException e) {
            LOG.warn("Found unsupported TIFF compression, converting TIFF to JPEG: " + e.getMessage());
            try {
                return PDImageXObject.createFromSeekableSource((SeekableSource)PageImageWriter.convertTiffToJpg(source), (String)name);
            }
            catch (UnsupportedOperationException ex) {
                if (ex.getMessage().contains("alpha channel")) {
                    LOG.warn("Found alpha channel image, JPEG compression failed, converting TIFF to PNG");
                    return PDImageXObject.createFromSeekableSource((SeekableSource)PageImageWriter.convertTiffToPng(source), (String)name);
                }
                throw ex;
            }
        }
    }

    public static SeekableSource convertTiffToJpg(SeekableSource source) throws IOException, TaskIOException {
        return PageImageWriter.convertImageTo(source, "jpeg");
    }

    public static SeekableSource convertTiffToPng(SeekableSource source) throws IOException, TaskIOException {
        return PageImageWriter.convertImageTo(source, "png");
    }

    private static FileType getFileType(SeekableSource source) {
        try {
            return FileTypeDetector.detectFileType((SeekableSource)source);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeekableSource convertImageTo(SeekableSource source, String format) throws IOException, TaskIOException {
        BufferedImage image = ImageIO.read(source.asNewInputStream());
        File tmpFile = IOUtils.createTemporaryBuffer((String)("." + format));
        FileImageOutputStream outputStream = new FileImageOutputStream(tmpFile);
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
            writer.setOutput(outputStream);
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (format.equals("jpeg")) {
                param.setCompressionMode(2);
                param.setCompressionQuality(1.0f);
            }
            writer.write(null, new IIOImage(image, null, null), param);
        }
        finally {
            org.sejda.commons.util.IOUtils.closeQuietly((Closeable)outputStream);
        }
        return SeekableSources.seekableSourceFrom((File)tmpFile);
    }

    private static Optional<SeekableSource> convertExifRotatedIf(SeekableSource source, String name) throws IOException, TaskIOException {
        int degrees = ExifHelper.getRotationBasedOnExifOrientation(source.asNewInputStream());
        if (degrees > 0) {
            BufferedImage orig = ImageIO.read(source.asNewInputStream());
            if (orig == null) {
                FileType type = FileTypeDetector.detectFileType((SeekableSource)source);
                throw new UnsupportedImageFormatException(type, name, null);
            }
            BufferedImage result = Thumbnails.of((BufferedImage[])new BufferedImage[]{orig}).scale(1.0).rotate((double)degrees).asBufferedImage();
            File tmpFile = IOUtils.createTemporaryBufferWithName((String)name);
            ImageIO.write((RenderedImage)result, PageImageWriter.getImageIOSaveFormat(source), tmpFile);
            return Optional.of(SeekableSources.seekableSourceFrom((File)tmpFile));
        }
        return Optional.empty();
    }

    private static String getImageIOSaveFormat(SeekableSource source) {
        FileType fileType = PageImageWriter.getFileType(source);
        if (fileType == FileType.JPEG) {
            return "jpg";
        }
        return "png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<SeekableSource> convertCMYKJpegIf(SeekableSource source, String name) throws IOException, TaskIOException {
        try {
            if (!FileType.JPEG.equals((Object)PageImageWriter.getFileType(source))) return Optional.empty();
            try (ImageInputStream iis = ImageIO.createImageInputStream(source.asNewInputStream());){
                ImageReader reader = ImageIO.getImageReadersByFormatName("jpg").next();
                boolean isCmyk = false;
                try {
                    ImageIO.setUseCache(false);
                    reader.setInput(iis);
                    Iterator<ImageTypeSpecifier> it = reader.getImageTypes(0);
                    while (it.hasNext()) {
                        ImageTypeSpecifier typeSpecifier = it.next();
                        if (typeSpecifier.getColorModel().getColorSpace().getType() != 9) continue;
                        isCmyk = true;
                    }
                    if (!isCmyk) return Optional.empty();
                    LOG.debug("Detected a CMYK JPEG image, will convert to RGB and save to a new file");
                    BufferedImage image = reader.read(0);
                    File tmpFile = IOUtils.createTemporaryBufferWithName((String)name);
                    ImageIO.write((RenderedImage)image, "jpg", tmpFile);
                    Optional<SeekableSource> optional = Optional.of(SeekableSources.seekableSourceFrom((File)tmpFile));
                    return optional;
                }
                finally {
                    reader.dispose();
                }
            }
        }
        catch (IIOException e) {
            if (!e.getMessage().startsWith("Not a JPEG stream")) throw e;
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<SeekableSource> convertICCGrayPngIf(SeekableSource source, String name) throws IOException, TaskIOException {
        try {
            if (!FileType.PNG.equals((Object)PageImageWriter.getFileType(source))) return Optional.empty();
            try (ImageInputStream iis = ImageIO.createImageInputStream(source.asNewInputStream());){
                ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
                boolean isICCGray = false;
                try {
                    ImageIO.setUseCache(false);
                    reader.setInput(iis);
                    Iterator<ImageTypeSpecifier> it = reader.getImageTypes(0);
                    while (it.hasNext()) {
                        ImageTypeSpecifier typeSpecifier = it.next();
                        ColorSpace colorSpace = typeSpecifier.getColorModel().getColorSpace();
                        if (!(colorSpace instanceof ICC_ColorSpace) || !(((ICC_ColorSpace)colorSpace).getProfile() instanceof ICC_ProfileGray)) continue;
                        isICCGray = true;
                        break;
                    }
                    if (!isICCGray) return Optional.empty();
                    LOG.debug("Detected a Gray PNG image, will convert to RGB and save to a new file");
                    BufferedImage original = reader.read(0);
                    BufferedImage rgb = PageImageWriter.toARGB(original);
                    File tmpFile = IOUtils.createTemporaryBufferWithName((String)name);
                    ImageIO.write((RenderedImage)rgb, "png", tmpFile);
                    Optional<SeekableSource> optional = Optional.of(SeekableSources.seekableSourceFrom((File)tmpFile));
                    return optional;
                }
                finally {
                    reader.dispose();
                }
            }
        }
        catch (IIOException e) {
            LOG.debug("Failed convertICCGrayPngIf()", (Throwable)e);
        }
        return Optional.empty();
    }

    private static BufferedImage toARGB(BufferedImage i) {
        BufferedImage rgb = new BufferedImage(i.getWidth(null), i.getHeight(null), 2);
        rgb.createGraphics().drawImage((Image)i, 0, 0, null);
        return rgb;
    }
}

