/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sejda.commons.util.RequireUtils;
import org.sejda.impl.sambox.component.OutlineUtils;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.MergeParameters;
import org.sejda.model.toc.ToCPolicy;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOfContentsCreator {
    private static final Logger LOG = LoggerFactory.getLogger(TableOfContentsCreator.class);
    private static final int DEFAULT_FONT_SIZE = 14;
    private static final int DEFAULT_MARGIN = 72;
    private static final String SEPARATOR = "  ";
    private final Deque<ToCItem> items = new LinkedList<ToCItem>();
    private PDDocument document;
    private PDRectangle pageSize = null;
    private float fontSize = 14.0f;
    private float margin = 72.0f;
    private PDFont font = PDType1Font.HELVETICA;
    private float lineHeight;
    private MergeParameters params;
    private PageTextWriter writer;
    private LinkedList<PDPage> generatedToC;

    public TableOfContentsCreator(MergeParameters params, PDDocument document) {
        RequireUtils.requireNotNullArg((Object)document, (String)"Containing document cannot be null");
        RequireUtils.requireNotNullArg((Object)params, (String)"Parameters cannot be null");
        this.document = document;
        this.params = params;
        this.writer = new PageTextWriter(document);
    }

    public void appendItem(String text, long pageNumber, PDPage page) {
        RequireUtils.requireNotBlank((String)text, (String)"ToC item cannot be blank");
        RequireUtils.requireArg((pageNumber > 0L ? 1 : 0) != 0, (String)"ToC item cannot point to a negative page");
        RequireUtils.requireNotNullArg((Object)page, (String)"ToC page cannot be null");
        this.requireNotAlreadyGenerated();
        if (this.shouldGenerateToC()) {
            this.items.add(new ToCItem(text, pageNumber, (PDAnnotation)this.linkAnnotationFor(page)));
        }
    }

    private PDAnnotationLink linkAnnotationFor(PDPage importedPage) {
        PDPageXYZDestination pageDest = OutlineUtils.pageDestinationFor(importedPage);
        PDAnnotationLink link = new PDAnnotationLink();
        link.setDestination((PDDestination)pageDest);
        link.setBorder(new COSArray(new COSBase[]{COSInteger.ZERO, COSInteger.ZERO, COSInteger.ZERO}));
        return link;
    }

    public int addToC() throws TaskException {
        return this.addToC(0);
    }

    public int addToC(int beforePageNumber) throws TaskException {
        PDPageTree pagesTree = this.document.getPages();
        LinkedList<PDPage> toc = this.generateToC();
        toc.descendingIterator().forEachRemaining(p -> {
            if (pagesTree.getCount() > 0) {
                pagesTree.insertBefore(p, pagesTree.get(beforePageNumber));
            } else {
                pagesTree.add(p);
            }
        });
        return toc.size();
    }

    private LinkedList<PDPage> generateToC() throws TaskIOException {
        if (this.generatedToC == null) {
            this.generatedToC = this._generateToC();
        }
        return this.generatedToC;
    }

    private LinkedList<PDPage> _generateToC() throws TaskIOException {
        int tocNumberOfPages = this._generateToC(0).size();
        return this._generateToC(tocNumberOfPages);
    }

    private LinkedList<PDPage> _generateToC(int tocNumberOfPages) throws TaskIOException {
        LinkedList<PDPage> pages = new LinkedList<PDPage>();
        this.recalculateDimensions();
        int maxRowsPerPage = (int)((this.pageSize().getHeight() - this.margin * 2.0f + this.lineHeight) / this.lineHeight);
        LinkedList<ToCItem> items = new LinkedList<ToCItem>(this.items);
        if (this.shouldGenerateToC()) {
            while (!items.isEmpty()) {
                int row = 0;
                float separatorWidth = this.stringLength(SEPARATOR);
                float separatingLineEndingX = this.getSeparatingLineEndingX(separatorWidth);
                PDPage page = this.createPage(pages);
                try (PDPageContentStream stream = new PDPageContentStream(this.document, page);){
                    while (!items.isEmpty() && row < maxRowsPerPage) {
                        ToCItem i = (ToCItem)items.peek();
                        if (Objects.nonNull(i)) {
                            float y = this.pageSize().getHeight() - this.margin - (float)row * this.lineHeight;
                            float x = this.margin;
                            List<String> lines = this.multipleLinesIfRequired(i.text, separatingLineEndingX, separatorWidth);
                            if (row + lines.size() > maxRowsPerPage) {
                                row = maxRowsPerPage;
                                continue;
                            }
                            items.poll();
                            for (int j = 0; j < lines.size(); ++j) {
                                String line = lines.get(j);
                                this.writeText(page, line, x, y);
                                if (j >= lines.size() - 1) continue;
                                y = this.pageSize().getHeight() - this.margin - (float)(++row) * this.lineHeight;
                            }
                            long pageNumber = i.page + (long)tocNumberOfPages;
                            String pageString = SEPARATOR + pageNumber;
                            float x2 = this.getPageNumberX(separatorWidth);
                            this.writeText(page, pageString, x2, y);
                            float spacing = (this.lineHeight - this.fontSize) / 2.0f;
                            float height = this.lineHeight * (float)lines.size() - 2.0f * spacing;
                            i.annotation.setRectangle(new PDRectangle(this.margin, y - spacing, this.pageSize().getWidth() - 2.0f * this.margin, height));
                            page.getAnnotations().add(i.annotation);
                            String lastLine = lines.get(lines.size() - 1);
                            stream.moveTo(this.margin + separatorWidth + this.stringLength(lastLine), y);
                            stream.lineTo(separatingLineEndingX, y);
                            stream.setLineWidth(0.5f);
                            stream.stroke();
                        }
                        ++row;
                    }
                }
                catch (IOException e) {
                    throw new TaskIOException("An error occurred while create the ToC", (Throwable)e);
                }
            }
            if (this.params.isBlankPageIfOdd() && pages.size() % 2 == 1) {
                PDPage lastTocPage = pages.getLast();
                PDPage blankPage = new PDPage(lastTocPage.getMediaBox());
                pages.add(blankPage);
            }
        }
        return pages;
    }

    private void requireNotAlreadyGenerated() {
        if (this.generatedToC != null) {
            throw new IllegalStateException("ToC has already been generated");
        }
    }

    private void writeText(PDPage page, String s, float x, float y) throws TaskIOException {
        this.writer.write(page, (Point2D)new Point2D.Float(x, y), s, this.font, Double.valueOf(this.fontSize), Color.BLACK);
    }

    private List<String> multipleLinesIfRequired(String text, float separatingLineEndingX, float separatorWidth) throws TaskIOException {
        float maxWidth = this.pageSize().getWidth() - this.margin - (this.pageSize().getWidth() - separatingLineEndingX) - separatorWidth;
        return FontUtils.wrapLines(text, this.font, this.fontSize, maxWidth, this.document);
    }

    private PDPage createPage(LinkedList<PDPage> pages) {
        LOG.debug("Creating new ToC page");
        PDPage page = new PDPage(this.pageSize());
        pages.add(page);
        return page;
    }

    private float getSeparatingLineEndingX(float separatorWidth) throws TaskIOException {
        return this.getPageNumberX(separatorWidth);
    }

    private float getPageNumberX(float separatorWidth) throws TaskIOException {
        return this.pageSize().getWidth() - this.margin - separatorWidth - this.stringLength(Long.toString(9999L));
    }

    private float stringLength(String text) throws TaskIOException {
        return this.writer.getStringWidth(text, this.font, this.fontSize);
    }

    public boolean hasToc() {
        return !this.items.isEmpty();
    }

    public boolean shouldGenerateToC() {
        return this.params.getTableOfContentsPolicy() != ToCPolicy.NONE;
    }

    public void pageSizeIfNotSet(PDRectangle pageSize) {
        this.requireNotAlreadyGenerated();
        if (this.pageSize == null) {
            this.pageSize = pageSize;
        }
    }

    private void recalculateDimensions() {
        float scalingFactor = this.pageSize().getHeight() / PDRectangle.A4.getHeight();
        this.fontSize = scalingFactor * 14.0f;
        this.margin = scalingFactor * 72.0f;
        this.lineHeight = (float)((double)this.fontSize + (double)this.fontSize * 0.7);
    }

    private PDRectangle pageSize() {
        return Optional.ofNullable(this.pageSize).orElse(PDRectangle.A4);
    }

    public float getFontSize() {
        return this.fontSize;
    }

    PDDocument getDoc() {
        return this.document;
    }

    private record ToCItem(String text, long page, PDAnnotation annotation) {
    }
}

