/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.excel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTable {
    private static final Logger LOG = LoggerFactory.getLogger(DataTable.class);
    private final List<List<String>> data = new ArrayList<List<String>>();
    private final TreeSet<Integer> pageNumbers = new TreeSet();

    public DataTable(int pageNumber) {
        this.pageNumbers.add(pageNumber);
    }

    public DataTable(Collection<Integer> pageNumbers) {
        this.pageNumbers.addAll(pageNumbers);
    }

    public DataTable addRow(String ... dataRow) {
        ArrayList<String> row = new ArrayList<String>();
        row.addAll(Arrays.asList(dataRow));
        this.addRow(row);
        return this;
    }

    public void addRow(List<String> dataRow) {
        this.data.add(dataRow);
    }

    public void addRows(List<List<String>> dataRows) {
        dataRows.forEach(this::addRow);
    }

    public List<String> headerRow() {
        return this.data.get(0);
    }

    public List<String> headerRowIgnoreBlanks() {
        return this.data.get(0).stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }

    public boolean hasSameHeaderAs(DataTable other) {
        String thisHeader = String.join((CharSequence)"", this.headerRowIgnoreBlanks()).trim();
        String otherHeader = String.join((CharSequence)"", other.headerRowIgnoreBlanks()).trim();
        LOG.debug("Comparing header columns: '{}' and '{}'", (Object)thisHeader, (Object)otherHeader);
        return thisHeader.equalsIgnoreCase(otherHeader);
    }

    public boolean hasSameHeaderBlanksIgnoredAs(DataTable other) {
        return this.headerRowIgnoreBlanks().equals(other.headerRowIgnoreBlanks());
    }

    public boolean hasSameColumnCountAs(DataTable other) {
        LOG.debug("Comparing header columns size: {} and {}", (Object)this.headerRow().size(), (Object)other.headerRow().size());
        return other.headerRow().size() == this.headerRow().size();
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public TreeSet<Integer> getPageNumbers() {
        return this.pageNumbers;
    }

    public DataTable mergeWith(DataTable other) {
        TreeSet<Integer> resultPageNumbers = new TreeSet<Integer>();
        resultPageNumbers.addAll(this.pageNumbers);
        resultPageNumbers.addAll(other.pageNumbers);
        DataTable result = new DataTable(resultPageNumbers);
        result.addRows(this.data);
        List<List<String>> otherData = other.data;
        if (this.hasSameHeaderAs(other)) {
            otherData.remove(0);
        }
        result.addRows(otherData);
        return result;
    }

    private boolean hasConsecutivePages() {
        Integer prev = null;
        for (Integer current : this.pageNumbers) {
            if (prev != null && prev != current - 1) {
                return false;
            }
            prev = current;
        }
        return true;
    }

    public String getPagesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.pageNumbers.size() > 1) {
            sb.append("Pages ");
            if (this.pageNumbers.size() > 2 && this.hasConsecutivePages()) {
                sb.append(this.pageNumbers.first()).append("-").append(this.pageNumbers.last());
                return sb.toString();
            }
            int i = 0;
            for (Integer pageNumber : this.pageNumbers) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(pageNumber);
                ++i;
            }
        } else {
            sb.append("Page ").append(this.pageNumbers.iterator().next());
        }
        return sb.toString();
    }

    public boolean hasData() {
        return this.data.size() > 0;
    }

    public int getColumnsCount() {
        int result = 0;
        for (List<String> row : this.data) {
            result = Math.max(row.size(), result);
        }
        return result;
    }

    public int getRowsCount() {
        return this.data.size();
    }

    public List<String> getColumn(int c) {
        ArrayList<String> result = new ArrayList<String>(this.getRowsCount());
        for (List<String> row : this.data) {
            result.add(DataTable.getOrEmpty(row, c));
        }
        return result;
    }

    public List<String> getRow(int r) {
        return this.data.get(r);
    }

    public DataTable mergeColumns(int c1, int c2) {
        DataTable result = new DataTable(this.getPageNumbers());
        for (List<String> row : this.data) {
            ArrayList<String> newRow = new ArrayList<String>(row.size() - 1);
            for (int c = 0; c < row.size(); ++c) {
                if (c == c2) continue;
                if (c == c1) {
                    String newValue = (DataTable.getOrEmpty(row, c1) + " " + DataTable.getOrEmpty(row, c2)).trim();
                    newRow.add(newValue);
                    continue;
                }
                newRow.add(DataTable.getOrEmpty(row, c));
            }
            result.addRow(newRow);
        }
        return result;
    }

    public void addBlankColumn(int index) {
        for (List<String> row : this.data) {
            row.add(index, "");
        }
    }

    private static String getOrEmpty(List<String> list, int index) {
        if (list.size() <= index) {
            return "";
        }
        return list.get(index);
    }

    public String toString() {
        int j;
        StringBuilder sb = new StringBuilder();
        int totalWidth = 0;
        int colCount = this.getColumnsCount();
        ArrayList<Integer> colWidths = new ArrayList<Integer>();
        for (int i = 0; i < colCount; ++i) {
            List<String> col = this.getColumn(i);
            int colWidth = 0;
            for (j = 0; j < col.size(); ++j) {
                colWidth = Math.max(colWidth, col.get(j).length());
            }
            colWidths.add(colWidth);
            totalWidth += colWidth;
        }
        String line = "+" + StringUtils.repeat((String)"-", (int)(totalWidth + colCount - 1)) + "+";
        for (int i = 0; i < this.getRowsCount(); ++i) {
            List<String> row = this.getRow(i);
            sb.append("\n").append(line).append("\n");
            for (j = 0; j < colWidths.size(); ++j) {
                String cellPadded = StringUtils.rightPad((String)"", (int)((Integer)colWidths.get(j)));
                if (j < row.size()) {
                    cellPadded = org.sejda.core.support.util.StringUtils.isolateRTLIfRequired((String)StringUtils.rightPad((String)row.get(j), (int)((Integer)colWidths.get(j))));
                }
                sb.append("|").append(cellPadded);
            }
            sb.append("|");
        }
        sb.append("\n").append(line).append("\n");
        return sb.toString();
    }
}

