/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.util;

import java.awt.geom.GeneralPath;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.commons.util.StringUtils;
import org.sejda.impl.sambox.component.TextWithFont;
import org.sejda.impl.sambox.component.font.FallbackFontsProvider;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.UnsupportedTextException;
import org.sejda.model.pdf.StandardType1Font;
import org.sejda.model.pdf.font.FontResource;
import org.sejda.model.pdf.font.Type0FontsProvider;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.FontMappers;
import org.sejda.sambox.pdmodel.font.FontMapping;
import org.sejda.sambox.pdmodel.font.PDCIDFont;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDFontDescriptor;
import org.sejda.sambox.pdmodel.font.PDSimpleFont;
import org.sejda.sambox.pdmodel.font.PDType0Font;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.font.PDType3CharProc;
import org.sejda.sambox.pdmodel.font.PDType3Font;
import org.sejda.sambox.pdmodel.font.PDVectorFont;
import org.sejda.sambox.util.BidiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FontUtils.class);
    private static final Map<StandardType1Font, PDType1Font> STANDARD_TYPE1_FONTS;
    public static PDFont HELVETICA;
    public static final FontResource[] TYPE0FONTS;
    public static final List<FallbackFontsProvider> FALLBACK_FONTS_PROVIDERS;
    private static Map<PDDocument, Map<String, PDFont>> loadedFontCache;
    public static final String REMARK_FROM_SEJDA_FONT_RESOURCE = "FromSejdaFontResource";

    private FontUtils() {
    }

    public static PDType1Font getStandardType1Font(StandardType1Font st1Font) {
        return STANDARD_TYPE1_FONTS.get(st1Font);
    }

    public static PDFont fontOrFallback(String text, PDFont font, PDDocument document) {
        if (!FontUtils.canDisplay(text, font)) {
            PDFont fallback = FontUtils.findFontFor(document, text, FontUtils.isBold(font), font);
            String fallbackName = fallback == null ? null : fallback.getName();
            LOG.debug("Text '{}' cannot be written with font {}, using fallback {}", new Object[]{text, font.getName(), fallbackName});
            return fallback;
        }
        return font;
    }

    public static void clearLoadedFontCache() {
        loadedFontCache.clear();
    }

    public static void clearLoadedFontCache(PDDocument document) {
        loadedFontCache.remove(document);
    }

    public static PDFont loadFont(PDDocument document, FontResource font) {
        PDType0Font pDType0Font;
        block10: {
            Map<String, PDFont> docCache;
            if (!loadedFontCache.containsKey(document)) {
                loadedFontCache.put(document, new HashMap());
            }
            if ((docCache = loadedFontCache.get(document)).containsKey(font.getResource())) {
                return docCache.get(font.getResource());
            }
            InputStream in = font.getFontStream();
            try {
                PDType0Font loaded = PDType0Font.load((PDDocument)document, (InputStream)in);
                loaded.getTransientMetadata().put(REMARK_FROM_SEJDA_FONT_RESOURCE, "true");
                LOG.trace("Loaded font {}", (Object)loaded.getName());
                docCache.put(font.getResource(), (PDFont)loaded);
                pDType0Font = loaded;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Failed to load font " + font, (Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return pDType0Font;
    }

    public static PDFont findFontFor(PDDocument document, String text) {
        return FontUtils.findFontFor(document, text, false, null);
    }

    public static PDFont findFontFor(PDDocument document, String text, boolean bold, PDFont originalFont) {
        for (FallbackFontsProvider provider : FALLBACK_FONTS_PROVIDERS) {
            PDFont fallback = provider.findFallbackFont(originalFont, document, text, bold);
            if (fallback == null) continue;
            LOG.debug("Found suitable font {} to display '{}', via provider {}", new Object[]{fallback.getName(), text, provider.getClass().getName()});
            return fallback;
        }
        PDFont firstPartialMatch = null;
        for (FontResource font : TYPE0FONTS) {
            PDFont loaded = FontUtils.loadFont(document, font);
            if (!FontUtils.canDisplay(text, loaded)) continue;
            firstPartialMatch = loaded;
            LOG.debug("Found suitable font {} to display '{}'", (Object)loaded, (Object)text);
            if (FontUtils.isBold(loaded) != bold) continue;
            return loaded;
        }
        return firstPartialMatch;
    }

    public static boolean isOnlyWhitespace(String text) {
        return text.replaceAll("\\p{Zs}", "").length() == 0;
    }

    public static String removeWhitespace(String text) {
        return text.replaceAll("\\p{Zs}", "").replaceAll("\\r\\n", "").replaceAll("\\n", "");
    }

    public static boolean canDisplaySpace(PDFont font) {
        try {
            String text = " ";
            byte[] encoded = font.encode(text);
            if (font.getStringWidth(text) <= 0.0f) {
                return false;
            }
            return FontUtils.areEncodeDecodeSame(font, text, encoded);
        }
        catch (IOException | IllegalArgumentException | NullPointerException | UnsupportedOperationException exception) {
            return false;
        }
    }

    public static boolean canDisplay(String text, PDFont font) {
        return FontUtils.canDisplayString(FontUtils.removeWhitespace(text), font);
    }

    private static boolean canDisplayString(String text, PDFont font) {
        if (font == null) {
            return false;
        }
        try {
            byte[] encoded = font.encode(text);
            int[] cid2gid = null;
            if (font instanceof PDType0Font) {
                PDType0Font type0Font = (PDType0Font)font;
                try {
                    cid2gid = FontUtils.readCIDToGIDMap(type0Font.getDescendantFont());
                }
                catch (Exception e) {
                    LOG.warn("Exception reading CIDToGIDMap: " + e.getMessage());
                }
            }
            if (font instanceof PDVectorFont) {
                PDVectorFont vectorFont = (PDVectorFont)font;
                ByteArrayInputStream in = new ByteArrayInputStream(encoded);
                while (((InputStream)in).available() > 0) {
                    int code = font.readCode((InputStream)in);
                    GeneralPath path = vectorFont.getPath(code);
                    if (path == null || path.getBounds2D().getWidth() == 0.0) {
                        return false;
                    }
                    if (cid2gid == null || code >= cid2gid.length || cid2gid[code] != 0) continue;
                    return false;
                }
            }
            if (!"true".equals(font.getTransientMetadata().get(REMARK_FROM_SEJDA_FONT_RESOURCE))) {
                return FontUtils.areEncodeDecodeSame(font, text, encoded);
            }
            return true;
        }
        catch (IOException | IllegalArgumentException | NullPointerException | UnsupportedOperationException exception) {
            return false;
        }
    }

    private static int[] readCIDToGIDMap(PDCIDFont font) throws IOException {
        int[] cid2gid = null;
        COSDictionary dict = font.getCOSObject();
        COSBase map = dict.getDictionaryObject(COSName.CID_TO_GID_MAP);
        if (map instanceof COSStream) {
            COSStream stream = (COSStream)map;
            InputStream in = stream.getUnfilteredStream();
            byte[] mapAsBytes = IOUtils.toByteArray((InputStream)in);
            IOUtils.closeQuietly((Closeable)in);
            int numberOfInts = mapAsBytes.length / 2;
            cid2gid = new int[numberOfInts];
            int offset = 0;
            for (int index = 0; index < numberOfInts; ++index) {
                int gid;
                cid2gid[index] = gid = (mapAsBytes[offset] & 0xFF) << 8 | mapAsBytes[offset + 1] & 0xFF;
                offset += 2;
            }
        }
        return cid2gid;
    }

    public static double calculateBBoxHeight(String text, PDFont font) {
        RequireUtils.requireNotNullArg((Object)font, (String)"Font cannot be null");
        double maxHeight = 0.0;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(font.encode(text));
            while (((InputStream)in).available() > 0) {
                PDSimpleFont simpleFont;
                String name;
                int code = font.readCode((InputStream)in);
                if (font instanceof PDType3Font) {
                    maxHeight = Math.max(maxHeight, Optional.ofNullable(((PDType3Font)font).getCharProc(code)).map(PDType3CharProc::getGlyphBBox).map(PDRectangle::toGeneralPath).map(p -> p.getBounds2D().getHeight()).orElse(0.0));
                    continue;
                }
                if (font instanceof PDVectorFont) {
                    maxHeight = Math.max(maxHeight, Optional.ofNullable(((PDVectorFont)font).getPath(code)).map(p -> p.getBounds2D().getHeight()).orElse(0.0));
                    continue;
                }
                if (!(font instanceof PDSimpleFont) || !Objects.nonNull(name = (String)Optional.ofNullable((simpleFont = (PDSimpleFont)font).getEncoding()).map(e -> e.getName(code)).orElse(null))) continue;
                maxHeight = Math.max(maxHeight, simpleFont.getPath(name).getBounds2D().getHeight());
            }
        }
        catch (IOException e2) {
            LOG.warn("An error occurred while calculating the highest glyph bbox", (Throwable)e2);
        }
        return maxHeight;
    }

    public static boolean isBold(PDFont font) {
        if (font.getName() == null) {
            return false;
        }
        String lowercasedName = font.getName().toLowerCase();
        return lowercasedName.contains("bold");
    }

    public static boolean isItalic(PDFont font) {
        if (font.getName() == null) {
            return false;
        }
        String lowercasedName = font.getName().toLowerCase();
        return lowercasedName.contains("italic") || lowercasedName.contains("oblique");
    }

    public static List<String> wrapLines(String rawLabel, PDFont font, float fontSize, double maxWidth, PDDocument document) throws TaskIOException {
        ArrayList<String> lines = new ArrayList<String>();
        String label = StringUtils.normalizeWhitespace((String)rawLabel);
        StringBuilder currentString = new StringBuilder();
        double currentWidth = 0.0;
        List<TextWithFont> resolvedStringsToFonts = FontUtils.resolveFonts(label, font, document);
        for (TextWithFont stringAndFont : resolvedStringsToFonts) {
            try {
                String[] words;
                PDFont resolvedFont = stringAndFont.getFont();
                String resolvedLabel = stringAndFont.getText();
                if (Objects.isNull(resolvedFont)) {
                    throw new UnsupportedTextException("Unable to find suitable font for string \"" + resolvedLabel + "\"", resolvedLabel);
                }
                for (String word : words = BidiUtils.visualToLogical((String)resolvedLabel).split("(?<=\\b)")) {
                    double textWidth = FontUtils.getSimpleStringWidth(word, resolvedFont, fontSize);
                    if (textWidth > maxWidth || word.length() > 10) {
                        PrimitiveIterator.OfInt codePointIterator = word.codePoints().iterator();
                        while (codePointIterator.hasNext()) {
                            int codePoint = (Integer)codePointIterator.next();
                            String ch = new String(Character.toChars(codePoint));
                            double chWidth = FontUtils.getSimpleStringWidth(ch, resolvedFont, fontSize);
                            if (currentWidth + chWidth > maxWidth) {
                                currentString.append("-");
                                lines.add(currentString.toString().trim());
                                currentString = new StringBuilder();
                                currentWidth = 0.0;
                            }
                            currentWidth += chWidth;
                            currentString.append(ch);
                        }
                        continue;
                    }
                    if (currentWidth + textWidth > maxWidth) {
                        lines.add(currentString.toString().trim());
                        currentString = new StringBuilder();
                        currentWidth = 0.0;
                    }
                    currentWidth += textWidth;
                    currentString.append(word);
                }
            }
            catch (IOException e) {
                throw new TaskIOException((Throwable)e);
            }
        }
        if (!currentString.toString().isEmpty()) {
            lines.add(currentString.toString().trim());
        }
        return lines;
    }

    public static double getSimpleStringWidth(String text, PDFont font, double fontSize) throws IOException {
        double textWidth = (double)(font.getStringWidth(text) / 1000.0f) * fontSize;
        if (textWidth == 0.0) {
            textWidth = (double)(font.getAverageFontWidth() / 1000.0f) * fontSize;
        }
        return textWidth;
    }

    public static List<TextWithFont> resolveFonts(String label, PDFont font, PDDocument document) {
        PDFont currentFont = font;
        StringBuilder currentString = new StringBuilder();
        ArrayList<TextWithFont> result = new ArrayList<TextWithFont>();
        PrimitiveIterator.OfInt codePointIterator = label.codePoints().iterator();
        while (codePointIterator.hasNext()) {
            int codePoint = (Integer)codePointIterator.next();
            String s = new String(Character.toChars(codePoint));
            PDFont f = FontUtils.fontOrFallback(s, font, document);
            if (s.equals(" ")) {
                if (!FontUtils.canDisplaySpace(f)) {
                    f = FontUtils.getStandardType1Font(StandardType1Font.HELVETICA);
                }
                if (f != currentFont) {
                    if (currentString.length() > 0) {
                        result.add(new TextWithFont(currentString.toString(), currentFont));
                    }
                    result.add(new TextWithFont(" ", f));
                    currentString = new StringBuilder();
                    currentFont = f;
                    continue;
                }
                currentString.append(s);
                continue;
            }
            if (currentFont == f) {
                currentString.append(s);
                continue;
            }
            if (currentString.length() > 0) {
                result.add(new TextWithFont(currentString.toString(), currentFont));
            }
            currentString = new StringBuilder(s);
            currentFont = f;
        }
        result.add(new TextWithFont(currentString.toString(), currentFont));
        for (TextWithFont each : result) {
            LOG.trace("Will write '{}' with {}", (Object)each.getText(), (Object)each.getFont());
        }
        return result;
    }

    public static List<String> resolveTextFragments(String input, PDFont font) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Integer> current = new ArrayList<Integer>();
        if (org.sejda.core.support.util.StringUtils.isRtl((String)input)) {
            result.add(input);
            return result;
        }
        for (int codePoint : input.codePoints().toArray()) {
            try {
                if (font.getWidth(codePoint) == 0.0f) {
                    if (current.size() > 0) {
                        StringBuilder s = new StringBuilder();
                        current.stream().map(Character::toChars).forEach(s::append);
                        result.add(s.toString());
                    }
                    result.add(new String(Character.toChars(codePoint)));
                    current = new ArrayList();
                    continue;
                }
                current.add(codePoint);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (current.size() > 0) {
            StringBuilder s = new StringBuilder();
            current.stream().map(Character::toChars).forEach(s::append);
            result.add(s.toString());
        }
        return result;
    }

    public static String removeUnsupportedCharacters(String text, PDDocument doc) {
        return FontUtils.replaceUnsupportedCharacters(text, doc, "");
    }

    public static String replaceUnsupportedCharacters(String text, PDDocument doc, String replacement) {
        List<TextWithFont> resolved = FontUtils.resolveFonts(text, HELVETICA, doc);
        HashSet unsupported = new HashSet();
        resolved.forEach(tf -> {
            if (tf.getFont() == null) {
                unsupported.add(tf.getText());
            }
        });
        ArrayList unsupportedSortedByLength = new ArrayList(unsupported);
        unsupportedSortedByLength.sort((o1, o2) -> Integer.valueOf(o2.length()).compareTo(o1.length()));
        String result = text;
        for (String s : unsupportedSortedByLength) {
            result = result.replaceAll(Pattern.quote(s), replacement);
        }
        return result;
    }

    public static boolean areEncodeDecodeSame(PDFont font, String text) throws IOException {
        return FontUtils.areEncodeDecodeSame(font, text, font.encode(text));
    }

    private static boolean areEncodeDecodeSame(PDFont font, String text, byte[] encoded) throws IOException {
        String decoded = FontUtils.decode(font, encoded);
        boolean result = org.sejda.core.support.util.StringUtils.equalsNormalized((String)text, (String)decoded);
        if (!result) {
            LOG.info("Font " + font.getName() + " cannot encode/decode text: '" + text + "', decoded was: '" + decoded + "' " + StringUtils.asUnicodes((String)text) + " " + StringUtils.asUnicodes((String)decoded));
        }
        return result;
    }

    public static void assertEncodeDecodeSame(PDFont font, String text) throws IOException {
        if (!FontUtils.areEncodeDecodeSame(font, text)) {
            throw new IllegalStateException("Font " + font.getName() + " cannot encode/decode text: " + text);
        }
    }

    public static String decode(PDFont font, byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        StringBuilder result = new StringBuilder();
        while (((InputStream)in).available() > 0) {
            int code = font.readCode((InputStream)in);
            result.append(font.toUnicode(code));
        }
        return result.toString();
    }

    static {
        EnumMap<StandardType1Font, PDType1Font> fontsCache = new EnumMap<StandardType1Font, PDType1Font>(StandardType1Font.class);
        fontsCache.put(StandardType1Font.CURIER, PDType1Font.COURIER);
        fontsCache.put(StandardType1Font.CURIER_BOLD, PDType1Font.COURIER_BOLD);
        fontsCache.put(StandardType1Font.CURIER_BOLD_OBLIQUE, PDType1Font.COURIER_BOLD_OBLIQUE);
        fontsCache.put(StandardType1Font.CURIER_OBLIQUE, PDType1Font.COURIER_OBLIQUE);
        fontsCache.put(StandardType1Font.HELVETICA, PDType1Font.HELVETICA);
        fontsCache.put(StandardType1Font.HELVETICA_BOLD, PDType1Font.HELVETICA_BOLD);
        fontsCache.put(StandardType1Font.HELVETICA_BOLD_OBLIQUE, PDType1Font.HELVETICA_BOLD_OBLIQUE);
        fontsCache.put(StandardType1Font.HELVETICA_OBLIQUE, PDType1Font.HELVETICA_OBLIQUE);
        fontsCache.put(StandardType1Font.SYMBOL, PDType1Font.SYMBOL);
        fontsCache.put(StandardType1Font.ZAPFDINGBATS, PDType1Font.ZAPF_DINGBATS);
        fontsCache.put(StandardType1Font.TIMES_BOLD, PDType1Font.TIMES_BOLD);
        fontsCache.put(StandardType1Font.TIMES_BOLD_ITALIC, PDType1Font.TIMES_BOLD_ITALIC);
        fontsCache.put(StandardType1Font.TIMES_ITALIC, PDType1Font.TIMES_ITALIC);
        fontsCache.put(StandardType1Font.TIMES_ROMAN, PDType1Font.TIMES_ROMAN);
        STANDARD_TYPE1_FONTS = Collections.unmodifiableMap(fontsCache);
        HELVETICA = PDType1Font.HELVETICA;
        TYPE0FONTS = (FontResource[])StreamSupport.stream(ServiceLoader.load(Type0FontsProvider.class).spliterator(), false).flatMap(p -> p.getFonts().stream()).sorted(Comparator.comparingInt(FontResource::priority)).toArray(FontResource[]::new);
        FALLBACK_FONTS_PROVIDERS = StreamSupport.stream(ServiceLoader.load(FallbackFontsProvider.class).spliterator(), false).sorted(Comparator.comparingInt(FallbackFontsProvider::getPriority)).collect(Collectors.toList());
        loadedFontCache = new HashMap<PDDocument, Map<String, PDFont>>();
    }

    public static class FontSubsetting {
        public final String fontName;
        public final boolean isSubset;
        public final PDFont subsetFont;

        public FontSubsetting(PDFont subsetFont) {
            this.subsetFont = subsetFont;
            String fontName = org.apache.commons.lang3.StringUtils.trimToEmpty((String)subsetFont.getName());
            String[] fontNameFragments = fontName.split("\\+");
            if (fontNameFragments.length == 2 && fontNameFragments[0].length() == 6) {
                this.isSubset = true;
                this.fontName = fontNameFragments[1];
            } else {
                this.isSubset = false;
                this.fontName = null;
            }
        }

        public PDFont loadOriginalOrSimilar(PDDocument document) {
            PDFont original = this.loadOriginal(document);
            if (original == null) {
                return this.loadSimilar(document);
            }
            return original;
        }

        public PDFont loadOriginal(PDDocument document) {
            String lookupName = this.fontName.replace("-", " ");
            LOG.debug("Searching the system for a font matching name '{}'", (Object)lookupName);
            FontMapping fontMapping = FontMappers.instance().getTrueTypeFont(lookupName, null);
            if (fontMapping != null && fontMapping.getFont() != null && !fontMapping.isFallback()) {
                TrueTypeFont mappedFont = (TrueTypeFont)fontMapping.getFont();
                try {
                    LOG.debug("Original font available on the system: {}", (Object)this.fontName);
                    return PDType0Font.load((PDDocument)document, (InputStream)mappedFont.getOriginalData());
                }
                catch (IOException ioe) {
                    LOG.warn("Failed to load font from system", (Throwable)ioe);
                    try {
                        mappedFont.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed closing font", (Throwable)e);
                    }
                }
            }
            return null;
        }

        public PDFont loadSimilar(PDDocument document) {
            String lookupName = this.fontName.replace("-", " ");
            PDFontDescriptor descriptor = new PDFontDescriptor(new COSDictionary());
            descriptor.setFontName(this.fontName.split("-")[0]);
            descriptor.setForceBold(FontUtils.isBold(this.subsetFont));
            descriptor.setItalic(FontUtils.isItalic(this.subsetFont));
            LOG.debug("Searching the system for a font matching name '{}' and description [name:{}, bold:{}, italic:{}]", new Object[]{lookupName, descriptor.getFontName(), descriptor.isForceBold(), descriptor.isItalic()});
            FontMapping fontMapping = FontMappers.instance().getTrueTypeFont(lookupName, descriptor);
            if (fontMapping != null && fontMapping.getFont() != null) {
                TrueTypeFont mappedFont = (TrueTypeFont)fontMapping.getFont();
                try {
                    if (fontMapping.isFallback()) {
                        LOG.debug("Fallback font available on the system: {} (for {})", (Object)mappedFont.getName(), (Object)this.fontName);
                    } else {
                        LOG.debug("Original font available on the system: {}", (Object)this.fontName);
                    }
                    return PDType0Font.load((PDDocument)document, (InputStream)mappedFont.getOriginalData());
                }
                catch (IOException ioe) {
                    LOG.warn("Failed to load font from system", (Throwable)ioe);
                    try {
                        mappedFont.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed closing font", (Throwable)e);
                    }
                }
            }
            return null;
        }
    }
}

