/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PagesExtractor;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.ExtractPagesParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractPagesTask
extends BaseTask<ExtractPagesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractPagesTask.class);
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocumentHandler sourceDocumentHandler;

    public void before(ExtractPagesParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(ExtractPagesParameters parameters) throws TaskException {
        int currentStep = 0;
        int totalSteps = parameters.getSourceList().size();
        for (PdfSource source : parameters.getSourceList()) {
            LOG.debug("Opening {}", (Object)source);
            this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
            this.sourceDocumentHandler = (PDDocumentHandler)source.open(this.documentLoader);
            this.sourceDocumentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
            Set pages = parameters.getPages(this.sourceDocumentHandler.getNumberOfPages());
            if (pages == null || pages.isEmpty()) {
                this.executionContext().assertTaskIsLenient(this.noPagesErrorMessage(source, parameters));
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).taskWarning(this.noPagesErrorMessage(source, parameters));
            } else {
                LOG.debug("Extracting pages from {}, one file per range is '{}' ", (Object)source, (Object)parameters.isSeparateFileForEachRange());
                try (PagesExtractor extractor = new PagesExtractor(this.sourceDocumentHandler.getUnderlyingPDDocument());){
                    for (Set pageSets : parameters.getPagesSets(this.sourceDocumentHandler.getNumberOfPages())) {
                        if (pageSets.isEmpty()) continue;
                        File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                        LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
                        int fileNumber = this.executionContext().incrementAndGetOutputDocumentsCounter();
                        String outName = Optional.ofNullable(parameters.getSpecificResultFilename(fileNumber)).orElseGet(() -> NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(fileNumber).page(((Integer)pageSets.iterator().next()).intValue())));
                        this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
                        LOG.trace("Extracting pages {}", (Object)pageSets);
                        extractor.retain(pageSets, this.executionContext());
                        if (new OptimizationRuler(parameters.getOptimizationPolicy()).apply(this.sourceDocumentHandler.getUnderlyingPDDocument()).booleanValue()) {
                            extractor.optimize();
                        }
                        extractor.setVersion(parameters.getVersion());
                        extractor.setCompress(parameters.isCompress());
                        extractor.save(tmpFile, parameters.discardOutline(), parameters.getOutput().getEncryptionAtRestPolicy());
                        extractor.reset();
                    }
                }
            }
            this.executionContext().assertHasOutputDocuments("The task didn't generate any output file");
            IOUtils.closeQuietly((Closeable)this.sourceDocumentHandler);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Pages extracted and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        this.closeResource();
    }

    private void closeResource() {
        IOUtils.closeQuietly((Closeable)this.sourceDocumentHandler);
    }

    private String noPagesErrorMessage(PdfSource<?> source, ExtractPagesParameters parameters) {
        if (parameters.isInvertSelection()) {
            return String.format("Document had all pages removed: %s", source.getName());
        }
        return String.format("No page has been selected for extraction from: %s", source.getName());
    }
}

