/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.SetMetadataParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.model.util.IOUtils;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.sejda.sambox.pdmodel.common.PDMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class SetMetadataTask
extends BaseTask<SetMetadataParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetMetadataTask.class);
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(SetMetadataParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SetMetadataParameters parameters) throws TaskException {
        int totalSteps = parameters.getSourceList().size();
        for (int sourceIndex = 0; sourceIndex < parameters.getSourceList().size(); ++sourceIndex) {
            PdfSource source = (PdfSource)parameters.getSourceList().get(sourceIndex);
            int fileNumber = this.executionContext().incrementAndGetOutputDocumentsCounter();
            try {
                LOG.debug("Opening {}", (Object)source);
                this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
                this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
                this.documentHandler.setUpdateProducerModifiedDate(parameters.isUpdateProducerModifiedDate());
                if (parameters.isUpdateProducerModifiedDate()) {
                    this.documentHandler.setCreatorOnPDDocument();
                }
                File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                PDDocument doc = this.documentHandler.getUnderlyingPDDocument();
                doc.setOnBeforeWriteAction(() -> {
                    LOG.debug("Setting metadata on temporary document.");
                    PDDocument doc1 = this.documentHandler.getUnderlyingPDDocument();
                    PDDocumentCatalog catalog = doc1.getDocumentCatalog();
                    if (parameters.isRemoveAllMetadata()) {
                        doc1.setDocumentInformation(new PDDocumentInformation());
                        catalog.setMetadata(null);
                        return;
                    }
                    PDDocumentInformation actualMeta = doc1.getDocumentInformation();
                    for (Map.Entry meta : parameters.getMetadata().entrySet()) {
                        LOG.trace("'{}' -> '{}'", meta.getKey(), meta.getValue());
                        actualMeta.setCustomMetadataValue((String)meta.getKey(), (String)meta.getValue());
                    }
                    for (String keyToRemove : parameters.getToRemove()) {
                        LOG.trace("Removing '{}'", (Object)keyToRemove);
                        actualMeta.removeMetadataField(keyToRemove);
                    }
                    if (catalog.getMetadata() != null) {
                        LOG.debug("Document has XMP metadata stream");
                        try {
                            this.updateXmpMetadata(catalog, actualMeta);
                        }
                        catch (RuntimeException ex) {
                            if (this.exceptionStackContains("Namespace for prefix 'xmp' has not been declared", ex)) {
                                this.fixMissingXmpNamespace(catalog);
                                this.updateXmpMetadata(catalog, actualMeta);
                            }
                            throw ex;
                        }
                    }
                });
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile, parameters.getOutput().getEncryptionAtRestPolicy());
                String outName = Optional.ofNullable(parameters.getSpecificResultFilename(fileNumber)).orElseGet(() -> NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(fileNumber)));
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            }
            finally {
                org.sejda.commons.util.IOUtils.closeQuietly((Closeable)this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(fileNumber).outOf(totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Metadata set and written to {}", (Object)parameters.getOutput());
    }

    private XPathFactory newXPathFactory() {
        try {
            XPathFactory f = XPathFactory.newInstance();
            f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return f;
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateDateNode(String tagName, Document document, Calendar calendar) throws XPathExpressionException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String value = "";
        if (calendar != null) {
            value = dateFormat.format(calendar.getTime());
        }
        this.updateTextNode(tagName, document, value);
    }

    private void updateTextNode(String tagName, Document document, String value) throws XPathExpressionException {
        XPath xPath = this.newXPathFactory().newXPath();
        Node node = (Node)xPath.compile("//*[name()='" + tagName + "']").evaluate(document, XPathConstants.NODE);
        if (value == null) {
            value = "";
        }
        if (node != null) {
            node.setTextContent(value);
        }
    }

    private boolean exceptionStackContains(String msg, Throwable ex) {
        if (ex != null && ex.getMessage() != null && ex.getMessage().contains(msg)) {
            return true;
        }
        if (ex != null && ex.getCause() != null) {
            return this.exceptionStackContains(msg, ex.getCause());
        }
        return false;
    }

    private void deleteAttr(String path, String attrName, Document document) throws XPathExpressionException {
        XPath xPath = this.newXPathFactory().newXPath();
        Node node = (Node)xPath.compile(path).evaluate(document, XPathConstants.NODE);
        if (node != null && node.getAttributes().getNamedItem(attrName) != null) {
            node.getAttributes().removeNamedItem(attrName);
        }
    }

    private void fixMissingXmpNamespace(PDDocumentCatalog catalog) throws IOException {
        try (InputStream is = catalog.getMetadata().createInputStream();){
            String metadataAsString = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            if (!metadataAsString.contains("xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\"")) {
                LOG.warn("Metadata seems to be missing xmlns:xmp namespace definition, adding it");
                metadataAsString = metadataAsString.replaceAll("<rdf:Description", "<rdf:Description xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\"");
                catalog.setMetadata(new PDMetadata((InputStream)new ByteArrayInputStream(metadataAsString.getBytes(StandardCharsets.UTF_8))));
            }
        }
    }

    private void updateXmpMetadata(PDDocumentCatalog catalog, PDDocumentInformation metadata) {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            f.setFeature("http://xml.org/sax/features/external-general-entities", false);
            f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            f.setXIncludeAware(false);
            f.setExpandEntityReferences(false);
            DocumentBuilder b = f.newDocumentBuilder();
            Document document = b.parse(catalog.getMetadata().createInputStream());
            this.deleteAttr("//*[@CreateDate]", "xmp:CreateDate", document);
            this.deleteAttr("//*[@ModifyDate]", "xmp:ModifyDate", document);
            this.deleteAttr("//*[@Producer]", "pdf:Producer", document);
            this.deleteAttr("//*[@CreatorTool]", "xmp:CreatorTool", document);
            this.deleteAttr("//*[@Keywords]", "pdf:Keywords", document);
            this.deleteAttr("//*[@MetadataDate]", "xmp:MetadataDate", document);
            this.updateDateNode("xmp:CreateDate", document, metadata.getCreationDate());
            this.updateDateNode("xmp:ModifyDate", document, metadata.getModificationDate());
            this.updateTextNode("pdf:Producer", document, metadata.getProducer());
            this.updateTextNode("xmp:CreatorTool", document, metadata.getCreator());
            this.updateTextNode("pdf:Keywords", document, metadata.getKeywords());
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(new Date());
            this.updateDateNode("xmp:MetadataDate", document, nowCalendar);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.setURIResolver(new NoopURIResolver());
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter writer = new StringWriter();
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(domSource, streamResult);
            String updatedXml = writer.getBuffer().toString();
            catalog.setMetadata(new PDMetadata((InputStream)new ByteArrayInputStream(updatedXml.getBytes(StandardCharsets.UTF_8))));
        }
        catch (SAXParseException ex) {
            LOG.warn("Failed to parse XMP metadata, skipping update", (Throwable)ex);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).taskWarning("Some metadata elements could not be updated");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to update XMP metadata", ex);
        }
    }

    public void after() {
        org.sejda.commons.util.IOUtils.closeQuietly((Closeable)this.documentHandler);
    }

    private static class NoopURIResolver
    implements URIResolver {
        private NoopURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return null;
        }
    }
}

