/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.impl.sambox.component.split.PagesPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByPageNumbersTask<T extends AbstractSplitByPageParameters>
extends BaseTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByPageNumbersTask.class);
    private int totalSteps;
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PagesPdfSplitter<T> splitter;

    public void before(T parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    public void execute(T parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
            this.document = ((PDDocumentHandler)source.open(this.documentLoader)).getUnderlyingPDDocument();
            this.splitter = new PagesPdfSplitter<T>(this.document, parameters, new OptimizationRuler(parameters.getOptimizationPolicy()).apply(this.document));
            LOG.debug("Starting split by page numbers for {} ", parameters);
            this.splitter.split(this.executionContext(), parameters.getOutputPrefix(), source);
            IOUtils.closeQuietly((Closeable)this.document);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        LOG.debug("Input documents split and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.document);
        this.splitter = null;
    }
}

