/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.util.HumanReadableSize;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.impl.sambox.component.split.AbstractPdfSplitter;
import org.sejda.impl.sambox.component.split.SizePdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.parameter.SplitBySizeParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitBySizeTask
extends BaseTask<SplitBySizeParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitBySizeTask.class);
    private int totalSteps;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocument document = null;
    private AbstractPdfSplitter<SplitBySizeParameters> splitter;

    public void before(SplitBySizeParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    public void execute(SplitBySizeParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
            this.document = ((PDDocumentHandler)source.open(this.documentLoader)).getUnderlyingPDDocument();
            this.splitter = new SizePdfSplitter(this.document, parameters, new OptimizationRuler(parameters.getOptimizationPolicy()).apply(this.document));
            LOG.debug("Starting split by size {}", (Object)HumanReadableSize.toString((long)parameters.getSizeToSplitAt()));
            this.splitter.split(this.executionContext(), parameters.getOutputPrefix(), source);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        LOG.debug("Input documents rotated and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.document);
        this.splitter = null;
    }
}

