/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.UnpackParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocumentNameDictionary;
import org.sejda.sambox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.sejda.sambox.pdmodel.common.PDNameTreeNode;
import org.sejda.sambox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpackTask
extends BaseTask<UnpackParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(UnpackTask.class);
    private int totalSteps;
    private PDDocumentHandler sourceDocumentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(UnpackParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UnpackParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            ++currentStep;
            try {
                LOG.debug("Opening {}", (Object)source);
                this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
                this.sourceDocumentHandler = (PDDocumentHandler)source.open(this.documentLoader);
                HashMap<String, PDComplexFileSpecification> names = new HashMap<String, PDComplexFileSpecification>();
                PDEmbeddedFilesNameTreeNode ef = Optional.ofNullable(this.sourceDocumentHandler.getUnderlyingPDDocument().getDocumentCatalog().getNames()).map(PDDocumentNameDictionary::getEmbeddedFiles).orElse(null);
                this.collectNamesVisitingTree((PDNameTreeNode<PDComplexFileSpecification>)ef, names);
                Stream.concat(names.values().stream(), this.sourceDocumentHandler.getPages().stream().flatMap(p -> p.getAnnotations().stream()).filter(a -> a instanceof PDAnnotationFileAttachment).map(a -> (PDAnnotationFileAttachment)a).map(PDAnnotationFileAttachment::getFile).filter(f -> f instanceof PDComplexFileSpecification).map(f -> (PDComplexFileSpecification)f)).forEach(this::unpack);
            }
            finally {
                IOUtils.closeQuietly((Closeable)this.sourceDocumentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Attachments unpacked and written to {}", (Object)parameters.getOutput());
    }

    private void unpack(PDComplexFileSpecification file) {
        Optional.ofNullable(file.getBestEmbeddedFile()).ifPresent(e -> {
            try {
                File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer();
                LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
                try (InputStream is = e.createInputStream();){
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)tmpFile);
                    LOG.debug("Attachment '{}' unpacked to temporary buffer", (Object)file.getFilename());
                }
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(file.getFilename()));
            }
            catch (IOException | TaskIOException ioe) {
                LOG.error("Unable to extract file", ioe);
            }
        });
    }

    private void collectNamesVisitingTree(PDNameTreeNode<PDComplexFileSpecification> node, Map<String, PDComplexFileSpecification> names) throws TaskIOException {
        try {
            if (Objects.nonNull(node)) {
                Map nodeNames = node.getNames();
                if (nodeNames != null) {
                    names.putAll(nodeNames);
                } else {
                    for (PDNameTreeNode currNode : node.getKids()) {
                        this.collectNamesVisitingTree((PDNameTreeNode<PDComplexFileSpecification>)currNode, names);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new TaskIOException((Throwable)ioe);
        }
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.sourceDocumentHandler);
    }
}

