/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.io.InputStream;
import org.sejda.model.input.Source;

public class ExifHelper {
    public static int getRotationBasedOnExifOrientation(InputStream inputStream) {
        try {
            int orientation = ExifHelper.readExifOrientation(ImageMetadataReader.readMetadata((InputStream)inputStream));
            return ExifHelper.getRotation(orientation);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static int getRotationBasedOnExifOrientation(Source<?> source) {
        try {
            return ExifHelper.getRotationBasedOnExifOrientation(source.getSeekableSource().asNewInputStream());
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private static int readExifOrientation(Metadata metadata) throws MetadataException {
        Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        return directory.getInt(274);
    }

    private static int getRotation(int orientation) {
        switch (orientation) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 90;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }
}

