/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.tests;

import com.github.romankh3.image.comparison.ImageComparison;
import com.github.romankh3.image.comparison.model.ImageComparisonResult;
import com.github.romankh3.image.comparison.model.ImageComparisonState;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Date;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.resizers.configurations.ScalingMode;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.rendering.PDFRenderer;
import org.sejda.tests.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelCompareUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PixelCompareUtils.class);
    private double percentSimilarityThreshold;

    public PixelCompareUtils() {
        this(99.99);
    }

    public PixelCompareUtils(double percentSimilarityThreshold) {
        this.percentSimilarityThreshold = percentSimilarityThreshold;
    }

    public static void assertIsSimilar(PDDocument actual, String doc2ResourcePath) {
        new PixelCompareUtils().assertSimilar(actual, doc2ResourcePath);
    }

    public void assertSimilar(PDDocument actual, String doc2ResourcePath) {
        try {
            PDDocument expected = new File(doc2ResourcePath).exists() ? PDFParser.parse((SeekableSource)SeekableSources.seekableSourceFrom((File)new File(doc2ResourcePath))) : PDFParser.parse((SeekableSource)SeekableSources.onTempFileSeekableSourceFrom((InputStream)TestUtils.customInput(doc2ResourcePath).getSource()));
            this.assertSimilar(actual, expected, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void assertSimilar(PDDocument actual, PDDocument expected) {
        this.assertSimilar(actual, expected, Integer.MAX_VALUE);
    }

    public void assertSimilar(PDDocument actual, PDDocument expected, int maxNumberOfPages) {
        try {
            if (actual.getNumberOfPages() != expected.getNumberOfPages()) {
                Assertions.fail((String)("Documents have different number of pages:" + actual.getNumberOfPages() + ", " + expected.getNumberOfPages()));
            }
            int numOfPages = Math.min(actual.getNumberOfPages(), maxNumberOfPages);
            for (int i = 0; i < numOfPages; ++i) {
                double percentSimilarity;
                LOG.info("Comparing page " + (i + 1));
                BufferedImage p1 = PixelCompareUtils.resizeTo(PixelCompareUtils.takeScreenshotOf(actual, i), 1024);
                BufferedImage p2 = PixelCompareUtils.resizeTo(PixelCompareUtils.takeScreenshotOf(expected, i), 1024);
                ImageComparisonResult comparisonResult = new ImageComparison(p1, p2).compareImages();
                if (ImageComparisonState.MATCH == comparisonResult.getImageComparisonState() || !((percentSimilarity = (double)(100.0f - comparisonResult.getDifferencePercent())) < this.percentSimilarityThreshold)) continue;
                String testName = PixelCompareUtils.getJunitTestName();
                File baseFolder = new File(SystemUtils.getJavaIoTmpDir(), "sejda-similarity-tests");
                File folder = new File(baseFolder, testName);
                folder.mkdirs();
                File f1 = new File(folder, "p" + (i + 1) + "_actual.png");
                File f2 = new File(folder, "p" + (i + 1) + "_expected.png");
                ImageIO.write((RenderedImage)p1, "png", f1);
                ImageIO.write((RenderedImage)p2, "png", f2);
                File f3 = new File(folder, "p" + (i + 1) + "_comparison.png");
                ImageIO.write((RenderedImage)comparisonResult.getResult(), "png", f3);
                LOG.error("Troubleshoot:\n" + f1 + "\n" + f2 + "\n\n" + f3);
                Assertions.fail((String)("Page " + (i + 1) + " differs, similarity: " + percentSimilarity + "%"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getJunitTestName() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = trace.length - 1; i > 0; --i) {
            StackTraceElement ste = trace[i];
            try {
                Class<?> cls = Class.forName(ste.getClassName());
                Method method = cls.getDeclaredMethod(ste.getMethodName(), new Class[0]);
                Test annotation = method.getAnnotation(Test.class);
                if (annotation == null) continue;
                return ste.getClassName() + "." + ste.getMethodName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return "unknownTest" + new Date().getTime();
    }

    public static BufferedImage takeScreenshotOf(PDDocument doc, int pageIndex) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(doc);
        return pdfRenderer.renderImageWithDPI(pageIndex, 150.0f);
    }

    private static BufferedImage resizeTo(BufferedImage image, int width) throws IOException {
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).scalingMode(ScalingMode.PROGRESSIVE_BILINEAR).width(width).asBufferedImage();
    }
}

