/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.tests;

import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.junit.jupiter.api.Assertions;
import org.sejda.commons.util.RequireUtils;
import org.sejda.commons.util.StringUtils;
import org.sejda.model.encryption.CipherBasedEncryptionAtRest;
import org.sejda.model.encryption.EncryptionAtRestPolicy;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.FileSource;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfStreamSource;
import org.sejda.model.input.StreamSource;
import org.sejda.model.input.TaskSource;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.util.IOUtils;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDPageLabelRange;
import org.sejda.sambox.pdmodel.common.PDPageLabels;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.text.PDFTextStripper;
import org.sejda.sambox.text.PDFTextStripperByArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    private static final NotInstanceOf NOT_INSTANCE_OF = new NotInstanceOf();

    private TestUtils() {
    }

    public static void setProperty(Object instance, String propertyName, Object propertyValue) {
        try {
            Field field = instance.getClass().getDeclaredField(propertyName);
            field.setAccessible(true);
            field.set(instance, propertyValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(String.format("Unable to set field %s", propertyName), e);
        }
    }

    public static void assertInvalidParameters(TaskParameters parameters) {
        Validator VALIDATOR = new ValidatorHolder().getValidator();
        Set violations = VALIDATOR.validate((Object)parameters, new Class[0]);
        for (ConstraintViolation violation : violations) {
            LOG.debug("{}: {}", (Object)violation.getPropertyPath(), (Object)violation.getMessage());
        }
        Assertions.assertFalse((boolean)violations.isEmpty());
    }

    public static void assertValidParameters(TaskParameters parameters) {
        Validator VALIDATOR = new ValidatorHolder().getValidator();
        Set violations = VALIDATOR.validate((Object)parameters, new Class[0]);
        Assertions.assertFalse((boolean)violations.isEmpty());
    }

    public static <T> void testEqualsAndHashCodes(T eq1, T eq2, T eq3, T diff) {
        Assertions.assertNotEquals(null, eq1);
        Assertions.assertNotEquals(eq1, (Object)NOT_INSTANCE_OF);
        Assertions.assertEquals(eq1, eq1);
        Assertions.assertEquals((int)eq1.hashCode(), (int)eq1.hashCode());
        Assertions.assertEquals(eq1, eq2);
        Assertions.assertEquals(eq2, eq1);
        Assertions.assertEquals((int)eq1.hashCode(), (int)eq2.hashCode());
        Assertions.assertNotEquals(eq2, diff);
        Assertions.assertNotEquals(diff, eq2);
        Assertions.assertNotEquals((int)diff.hashCode(), (int)eq2.hashCode());
        Assertions.assertEquals(eq1, eq2);
        Assertions.assertEquals(eq2, eq3);
        Assertions.assertEquals(eq1, eq3);
        Assertions.assertEquals((int)eq1.hashCode(), (int)eq2.hashCode());
        Assertions.assertEquals((int)eq2.hashCode(), (int)eq3.hashCode());
        Assertions.assertEquals((int)eq1.hashCode(), (int)eq3.hashCode());
    }

    private static Cipher getCipher(int mode) {
        String salt = "9qZGubQY4B6Ra7GU5ZN9";
        String key = "MjxHL4QHjWqQt2qfYN6Z1whe6VJvJKfk3xfDBZJCgv0fqdksKkHhbrWy7Lqj9qNEZwA";
        return TestUtils.getCipher(salt, key, mode);
    }

    public static EncryptionAtRestPolicy getEncryptionAtRestPolicy() {
        return new CipherBasedEncryptionAtRest(TestUtils::getCipher);
    }

    private static File encryptedAtRestFile(TaskSource<?> source) throws IOException {
        return TestUtils.encryptedAtRest(source.getSeekableSource().asNewInputStream(), source.getName());
    }

    private static File encryptedAtRest(InputStream in, String name) {
        try {
            File file = IOUtils.createTemporaryBufferWithName((String)name);
            OutputStream out = TestUtils.getEncryptionAtRestPolicy().encrypt((OutputStream)new FileOutputStream(file));
            org.sejda.commons.util.IOUtils.copy((InputStream)in, (OutputStream)out);
            org.sejda.commons.util.IOUtils.closeQuietly((Closeable)out);
            org.sejda.commons.util.IOUtils.closeQuietly((Closeable)in);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StreamSource encryptedAtRest(StreamSource source) throws IOException {
        File file = TestUtils.encryptedAtRestFile(source);
        StreamSource result = StreamSource.newInstance((InputStream)new FileInputStream(file), (String)source.getName());
        result.setEncryptionAtRestPolicy(TestUtils.getEncryptionAtRestPolicy());
        return result;
    }

    public static FileSource encryptedAtRest(FileSource source) throws IOException {
        File file = TestUtils.encryptedAtRest(source.getSeekableSource().asNewInputStream(), source.getName());
        FileSource result = FileSource.newInstance((File)file);
        result.setEncryptionAtRestPolicy(TestUtils.getEncryptionAtRestPolicy());
        return result;
    }

    public static PdfStreamSource encryptedAtRest(PdfStreamSource source) throws IOException {
        File file = TestUtils.encryptedAtRestFile(source);
        PdfStreamSource result = PdfStreamSource.newInstanceWithPassword((InputStream)new FileInputStream(file), (String)source.getName(), (String)source.getPassword());
        result.setEncryptionAtRestPolicy(TestUtils.getEncryptionAtRestPolicy());
        return result;
    }

    public static PdfFileSource encryptedAtRest(PdfFileSource source) throws IOException {
        File file = TestUtils.encryptedAtRestFile(source);
        PdfFileSource result = PdfFileSource.newInstanceWithPassword((File)file, (String)source.getPassword());
        result.setEncryptionAtRestPolicy(TestUtils.getEncryptionAtRestPolicy());
        return result;
    }

    public static String getPageText(PDPage page) throws IOException {
        PDFTextStripperByArea textStripper = new PDFTextStripperByArea();
        PDRectangle pageSize = page.getCropBox();
        Rectangle cropBoxRectangle = new Rectangle(0, 0, (int)pageSize.getWidth(), (int)pageSize.getHeight());
        if (page.getRotation() == 90 || page.getRotation() == 270) {
            cropBoxRectangle = new Rectangle(0, 0, (int)pageSize.getHeight(), (int)pageSize.getWidth());
        }
        textStripper.setSortByPosition(true);
        textStripper.addRegion("area1", (Rectangle2D)cropBoxRectangle);
        textStripper.extractRegions(page);
        return textStripper.getTextForRegion("area1");
    }

    public static void withPageText(PDPage page, Consumer<String> callback) {
        try {
            callback.accept(TestUtils.getPageText(page));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static String getPageTextNormalized(PDPage page) throws IOException {
        return StringUtils.normalizeLineEndings((String)TestUtils.getPageText(page));
    }

    public static String getDocTextNormalized(PDDocument doc) throws IOException {
        return StringUtils.normalizeLineEndings((String)new PDFTextStripper().getText(doc));
    }

    public static void assertPageText(PDPage page, String text) {
        TestUtils.withPageText(page, pageText -> Assertions.assertEquals((Object)text, (Object)pageText.replaceAll("[^A-Za-z0-9]", "")));
    }

    public static void assertPageTextExact(PDPage page, String text) {
        TestUtils.withPageText(page, pageText -> Assertions.assertEquals((Object)text, (Object)pageText));
    }

    public static void assertPageTextExactLines(PDPage page, String text) {
        TestUtils.withPageText(page, pageText -> Assertions.assertEquals((Object)StringUtils.normalizeLineEndings((String)text), (Object)StringUtils.normalizeLineEndings((String)pageText)));
    }

    public static void assertDocTextExactLines(PDDocument doc, String text) throws IOException {
        Assertions.assertEquals((Object)text, (Object)TestUtils.getDocTextNormalized(doc));
    }

    public static void assertPageTextContains(PDPage page, String text) {
        TestUtils.withPageText(page, pageText -> {
            pageText = StringUtils.normalizeWhitespace((String)pageText);
            pageText = pageText.replaceAll("\\s", "");
            MatcherAssert.assertThat((Object)pageText, (Matcher)Matchers.containsString((String)text.replaceAll("\\s", "")));
        });
    }

    public static void assertPageTextDoesNotContain(PDPage page, String text) {
        TestUtils.withPageText(page, pageText -> {
            pageText = StringUtils.normalizeWhitespace((String)pageText);
            pageText = pageText.replaceAll("\\s", "");
            MatcherAssert.assertThat((Object)pageText, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)text.replaceAll("\\s", ""))));
        });
    }

    public static <T> List<T> getAnnotationsOf(PDPage page, Class<T> clazz) {
        return TestUtils.iteratorToList(page.getAnnotations().stream().filter(clazz::isInstance).map(a -> a).iterator());
    }

    public static <T> List<T> iteratorToList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static void assertPDRectanglesEqual(PDRectangle expected, PDRectangle actual) {
        Assertions.assertEquals((double)expected.getLowerLeftX(), (double)actual.getLowerLeftX(), (double)0.1);
        Assertions.assertEquals((double)expected.getLowerLeftY(), (double)actual.getLowerLeftY(), (double)0.1);
        Assertions.assertEquals((double)expected.getWidth(), (double)actual.getWidth(), (double)0.1);
        Assertions.assertEquals((double)expected.getHeight(), (double)actual.getHeight(), (double)0.1);
    }

    public static void assertPageDestination(PDAnnotationLink link, PDPage expectedPage) throws IOException {
        PDPage actualPage = ((PDPageDestination)link.getDestination()).getPage();
        Assertions.assertEquals((Object)expectedPage, (Object)actualPage);
    }

    public static void assertPageLabelIndexesAre(PDPageLabels labels, Integer ... expected) {
        MatcherAssert.assertThat(labels.getLabels().keySet(), (Matcher)CoreMatchers.is(new HashSet<Integer>(Arrays.asList(expected))));
    }

    public static void assertPageLabelRangeIs(PDPageLabels labels, int startPage, PDPageLabelRange expected) {
        PDPageLabelRange actual = labels.getPageLabelRange(startPage);
        Assertions.assertNotNull((Object)actual, (String)("No page label range found at index: " + startPage + ". " + labels.getLabels().keySet()));
        MatcherAssert.assertThat((String)("Difference at index: " + startPage), (Object)actual.getCOSObject().toString(), (Matcher)CoreMatchers.is((Object)expected.getCOSObject().toString()));
    }

    public static void assertPageLabelRangeIsDefault(PDPageLabels labels, int startPage) {
        PDPageLabelRange defaultLabel = new PDPageLabelRange();
        defaultLabel.setStyle("D");
        TestUtils.assertPageLabelRangeIs(labels, startPage, defaultLabel);
    }

    public static void assertPageLabelRangeIs(PDPageLabels labels, int startPage, String style) {
        TestUtils.assertPageLabelRangeIs(labels, startPage, new PDPageLabelRange(style, null, null));
    }

    public static void assertPageLabelRangeIs(PDPageLabels labels, int startPage, String style, String prefix, Integer start) {
        TestUtils.assertPageLabelRangeIs(labels, startPage, new PDPageLabelRange(style, prefix, start));
    }

    private static SecretKeySpec keyToSpec(String salt, String key) throws NoSuchAlgorithmException {
        byte[] keyBytes = (salt + key).getBytes(StandardCharsets.UTF_8);
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        keyBytes = sha.digest(keyBytes);
        keyBytes = Arrays.copyOf(keyBytes, 16);
        return new SecretKeySpec(keyBytes, "AES");
    }

    public static Cipher getCipher(String salt, String key, int mode) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(mode, TestUtils.keyToSpec(salt, key));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static PdfStreamSource shortInput() {
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/short-test-file.pdf"), (String)"short-test-file.pdf");
    }

    public static PdfStreamSource regularInput() {
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/test-pdf.pdf"), (String)"test-file.pdf");
    }

    public static PdfStreamSource mediumInput() {
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/medium_test.pdf"), (String)"medium-test-file.pdf");
    }

    public static PdfStreamSource largeInput() {
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/large_test.pdf"), (String)"large-test-file.pdf");
    }

    public static PdfStreamSource largeOutlineInput() {
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/large_outline.pdf"), (String)"large-outline-test-file.pdf");
    }

    public static PdfStreamSource encryptedInput() {
        return PdfStreamSource.newInstanceWithPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/encrypted_AES128_user_pwd.pdf"), (String)"encrypted-test-file.pdf", (String)"test");
    }

    public static PdfStreamSource formInput() {
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/forms/two_pages_form.pdf"), (String)"test-form.pdf");
    }

    public static PdfStreamSource stronglyEncryptedInput() {
        return PdfStreamSource.newInstanceWithPassword((InputStream)TestUtils.class.getResourceAsStream("/pdf/encrypted_AES256_user_pwd.pdf"), (String)"strongly-encrypted-test-file.pdf", (String)"test");
    }

    public static PdfStreamSource customInput(String path) {
        return TestUtils.customInput(path, RandomStringUtils.randomAlphanumeric((int)16) + ".pdf");
    }

    public static PdfStreamSource customInput(String path, String name) {
        RequireUtils.requireNotBlank((String)name, (String)"Name cannot be blank");
        return PdfStreamSource.newInstanceNoPassword((InputStream)TestUtils.class.getClassLoader().getResourceAsStream(path), (String)name);
    }

    public static PdfFileSource customInputAsFileSource(String path) {
        String filename = new File(path).getName();
        return TestUtils.customInputAsFileSource(path, filename);
    }

    public static PdfFileSource customInputAsFileSource(String path, String filename) {
        RequireUtils.requireNotBlank((String)filename, (String)"Name cannot be blank");
        return PdfFileSource.newInstanceNoPassword((File)TestUtils.streamToTmpFile(TestUtils.class.getClassLoader().getResourceAsStream(path), filename));
    }

    public static PdfFileSource customInput(PDDocument doc, String name) {
        try {
            File tmp = IOUtils.createTemporaryBufferWithName((String)name);
            doc.writeTo(tmp, new WriteOption[0]);
            return PdfFileSource.newInstanceNoPassword((File)tmp);
        }
        catch (IOException | TaskIOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PdfStreamSource customEncryptedInput(String path, String password) {
        return PdfStreamSource.newInstanceWithPassword((InputStream)TestUtils.class.getClassLoader().getResourceAsStream(path), (String)(RandomStringUtils.randomAlphanumeric((int)16) + ".pdf"), (String)password);
    }

    public static StreamSource customNonPdfInput(String path) {
        String extension = FilenameUtils.getExtension((String)path);
        String filename = new File(path).getName();
        return TestUtils.customNonPdfInput(path, filename);
    }

    public static StreamSource customNonPdfInput(String path, String filename) {
        RequireUtils.requireNotBlank((String)filename, (String)"Name cannot be blank");
        return StreamSource.newInstance((InputStream)TestUtils.class.getClassLoader().getResourceAsStream(path), (String)filename);
    }

    public static FileSource customNonPdfInputAsFileSource(String path) {
        String filename = new File(path).getName();
        return TestUtils.customNonPdfInputAsFileSource(path, filename);
    }

    public static FileSource customNonPdfInputAsFileSource(String path, String filename) {
        RequireUtils.requireNotBlank((String)filename, (String)"Name cannot be blank");
        return FileSource.newInstance((File)TestUtils.streamToTmpFile(TestUtils.class.getClassLoader().getResourceAsStream(path), filename));
    }

    public static File streamToTmpFile(InputStream in, String filename) {
        try {
            File tmp = IOUtils.createTemporaryBufferWithName((String)filename);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            org.sejda.commons.util.IOUtils.copy((InputStream)in, (OutputStream)out);
            org.sejda.commons.util.IOUtils.closeQuietly((Closeable)out);
            org.sejda.commons.util.IOUtils.closeQuietly((Closeable)in);
            return tmp;
        }
        catch (IOException | TaskIOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class ValidatorHolder {
        private Validator validator;

        private ValidatorHolder() {
            Configuration validationConfig = Validation.byDefaultProvider().configure();
            validationConfig.ignoreXmlConfiguration();
            validationConfig.messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator());
            ValidatorFactory factory = validationConfig.buildValidatorFactory();
            this.validator = factory.getValidator();
        }

        public Validator getValidator() {
            return this.validator;
        }
    }

    private static final class NotInstanceOf {
        private NotInstanceOf() {
        }
    }
}

