/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.tests.tasks;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.sejda.model.image.ImageColorType;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.base.SingleOrMultipleOutputTaskParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.parameter.image.AbstractPdfToMultipleImageParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.tests.TestUtils;
import org.sejda.tests.tasks.BaseTaskTest;
import org.sejda.tests.tasks.TestableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleImageConversionTaskTest<T extends AbstractPdfToMultipleImageParameters>
extends BaseTaskTest<T>
implements TestableTask<T> {
    private static Logger LOG = LoggerFactory.getLogger(MultipleImageConversionTaskTest.class);

    public abstract T getMultipleImageParametersWithoutSource(ImageColorType var1);

    @Test
    public void testExecuteEncryptedStreamToMultipleImage() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.GRAY_SCALE);
        parameters.addSource((PdfSource)TestUtils.encryptedInput());
        this.doExecute((AbstractPdfToMultipleImageParameters)parameters, 4);
    }

    @Test
    public void testExecuteStreamToMultipleImage() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.GRAY_SCALE);
        parameters.addSource((PdfSource)TestUtils.customInput("pdf/test_jpg.pdf"));
        this.doExecute((AbstractPdfToMultipleImageParameters)parameters, 1);
    }

    @Test
    public void testExecuteStreamToMultipleImageWithPageSelection() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.GRAY_SCALE);
        parameters.addSource((PdfSource)TestUtils.shortInput());
        parameters.addPageRange(new PageRange(2, 3));
        this.doExecute((AbstractPdfToMultipleImageParameters)parameters, 2);
    }

    @Test
    public void testMultipleInputs() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.GRAY_SCALE);
        parameters.addSource((PdfSource)TestUtils.mediumInput());
        parameters.addSource((PdfSource)TestUtils.regularInput());
        parameters.addPageRange(new PageRange(1, 1));
        parameters.setOutputPrefix("[BASENAME]-[PAGENUMBER]");
        this.doExecute((AbstractPdfToMultipleImageParameters)parameters, 2);
    }

    @Test
    public void encryptionAtRestTest() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.GRAY_SCALE);
        parameters.addSource((PdfSource)TestUtils.encryptedAtRest(TestUtils.mediumInput()));
        parameters.addSource((PdfSource)TestUtils.encryptedAtRest(TestUtils.regularInput()));
        parameters.addPageRange(new PageRange(1, 1));
        parameters.setOutputPrefix("[BASENAME]-[PAGENUMBER]");
        this.doExecute((AbstractPdfToMultipleImageParameters)parameters, 2);
    }

    @Test
    public void specificResultFilenames() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.GRAY_SCALE);
        parameters.addSource((PdfSource)TestUtils.encryptedInput());
        parameters.setOutputPrefix("[FILENUMBER]_[BASENAME]");
        this.testContext.directoryOutputTo((SingleOrMultipleOutputTaskParameters)parameters);
        parameters.addSpecificResultFilename("one");
        parameters.addSpecificResultFilename("two");
        String ext = parameters.getOutputImageType().getExtension();
        this.execute((TaskParameters)parameters);
        this.testContext.assertTaskCompleted();
        this.testContext.assertOutputSize(4).assertOutputContainsFilenames("one." + ext, "two." + ext, "3_encrypted-test-file." + ext, "4_encrypted-test-file." + ext);
    }

    @Test
    public void encryptionAtRestRoundTrip() throws IOException {
        T parameters = this.getMultipleImageParametersWithoutSource(ImageColorType.COLOR_RGB);
        parameters.addSource((PdfSource)TestUtils.encryptedAtRest(TestUtils.shortInput()));
        parameters.addSource((PdfSource)TestUtils.encryptedAtRest(TestUtils.mediumInput()));
        parameters.addPageRange(new PageRange(1, 1));
        this.testContext.directoryOutputTo((SingleOrMultipleOutputTaskParameters)parameters);
        parameters.getOutput().setEncryptionAtRestPolicy(TestUtils.getEncryptionAtRestPolicy());
        this.execute((TaskParameters)parameters);
        this.testContext.assertTaskCompleted();
        this.testContext.assertNoTaskWarnings();
        this.testContext.assertOutputSize(2).forEachRawOutput(path -> {
            try {
                BufferedImage image = ImageIO.read(TestUtils.getEncryptionAtRestPolicy().decrypt((InputStream)new FileInputStream(path.toFile())));
                Assertions.assertNotNull((Object)image);
                Assertions.assertTrue((image.getHeight() > 0 ? 1 : 0) != 0);
                Assertions.assertTrue((image.getWidth() > 0 ? 1 : 0) != 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void doExecute(AbstractPdfToMultipleImageParameters parameters, int size) throws IOException {
        this.testContext.directoryOutputTo((SingleOrMultipleOutputTaskParameters)parameters);
        this.execute((TaskParameters)parameters);
        this.testContext.assertTaskCompleted();
        this.testContext.assertOutputSize(size).forEachRawOutput(p -> {
            try {
                BufferedImage ri = ImageIO.read(p.toFile());
                Assertions.assertTrue((ri.getHeight() > 0 ? 1 : 0) != 0);
                Assertions.assertTrue((ri.getWidth() > 0 ? 1 : 0) != 0);
            }
            catch (Exception e) {
                LOG.error("Test failed", (Throwable)e);
                Assertions.fail((String)e.getMessage());
            }
        });
    }
}

