/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.tests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.AbstractNotificationEvent;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionStartedEvent;
import org.sejda.model.notification.event.TaskExecutionWarningEvent;

public final class TestListenerFactory {
    private TestListenerFactory() {
    }

    public static TestListenerPercentage newPercentageListener() {
        return new TestListenerPercentage();
    }

    public static TestListenerStart newStartListener() {
        return new TestListenerStart();
    }

    public static TestListenerFailed newFailedListener() {
        return new TestListenerFailed();
    }

    public static TestListenerWarnings newWarningsListener() {
        return new TestListenerWarnings();
    }

    public static <T extends AbstractNotificationEvent> TestListenerAny<T> newGeneralListener() {
        return new TestListenerAny();
    }

    public static class TestListenerPercentage
    implements EventListener<PercentageOfWorkDoneChangedEvent> {
        private BigDecimal percentage;
        private boolean undeterminate;

        public void onEvent(PercentageOfWorkDoneChangedEvent event) {
            this.percentage = event.getPercentage();
            this.undeterminate = event.isUndetermined();
        }

        public BigDecimal getPercentage() {
            return this.percentage;
        }

        public boolean isUndeterminate() {
            return this.undeterminate;
        }
    }

    public static class TestListenerStart
    implements EventListener<TaskExecutionStartedEvent> {
        private boolean started = false;

        public void onEvent(TaskExecutionStartedEvent event) {
            this.started = true;
        }

        public boolean isStarted() {
            return this.started;
        }
    }

    public static class TestListenerFailed
    implements EventListener<TaskExecutionFailedEvent> {
        private boolean failed = false;

        public void onEvent(TaskExecutionFailedEvent event) {
            this.failed = true;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public static class TestListenerWarnings
    implements EventListener<TaskExecutionWarningEvent> {
        private List<String> warnings = new ArrayList<String>();

        public void onEvent(TaskExecutionWarningEvent event) {
            this.warnings.add(event.getWarning());
        }

        public List<String> getWarnings() {
            return this.warnings;
        }
    }

    public static class TestListenerAny<T extends AbstractNotificationEvent>
    implements EventListener<T> {
        private boolean listened = false;

        public void onEvent(T event) {
            this.listened = true;
        }

        public boolean hasListened() {
            return this.listened;
        }
    }
}

