/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.tests.tasks;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.context.SejdaConfiguration;
import org.sejda.core.service.DefaultTaskExecutionService;
import org.sejda.model.exception.TaskException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.tests.TestUtils;
import org.sejda.tests.tasks.TaskTestContext;
import org.sejda.tests.tasks.TestableTask;

public abstract class BaseTaskTest<T extends TaskParameters>
implements TestableTask<T> {
    public final TaskTestContext testContext = new TaskTestContext();
    private SejdaConfiguration configuration;
    private DefaultTaskExecutionService victim;

    @BeforeEach
    public void setUp() throws TaskException {
        this.configuration = (SejdaConfiguration)Mockito.mock(SejdaConfiguration.class);
        Mockito.when((Object)this.configuration.getTask((TaskParameters)ArgumentMatchers.any())).thenReturn(this.getTask());
        this.victim = new DefaultTaskExecutionService(this.configuration);
    }

    public void executeWithValidation(TaskParameters parameters) {
        Mockito.when((Object)this.configuration.isValidation()).thenReturn((Object)Boolean.TRUE);
        this.testContext.listenForTaskFailure();
        this.testContext.listenForTaskWarnings();
        this.victim.execute(parameters);
    }

    public void execute(TaskParameters parameters) {
        Mockito.when((Object)this.configuration.isValidation()).thenReturn((Object)Boolean.FALSE);
        this.testContext.listenForTaskFailure();
        this.testContext.listenForTaskWarnings();
        this.victim.execute(parameters);
    }

    @AfterEach
    public void closeContext() {
        IOUtils.closeQuietly((Closeable)this.testContext);
    }

    public static void assertPageText(PDPage page, String text) {
        TestUtils.assertPageText(page, text);
    }

    public static void assertPageTextExactLines(PDPage page, String text) {
        TestUtils.assertPageTextExactLines(page, text);
    }

    public static void assertPageTextContains(PDPage page, String text) {
        TestUtils.assertPageTextContains(page, text);
    }

    public static void assertMediaBox(PDPage page, float width, float height) {
        Assertions.assertEquals((double)page.getMediaBox().getWidth(), (double)width, (double)0.01);
        Assertions.assertEquals((double)page.getMediaBox().getHeight(), (double)height, (double)0.01);
    }

    public static <T> List<T> getAnnotationsOf(PDPage page, Class<T> clazz) {
        return TestUtils.getAnnotationsOf(page, clazz);
    }

    public static List<Integer> getPagesContainingImages(PDDocument doc) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < doc.getNumberOfPages(); ++i) {
            PDPage page = doc.getPage(i);
            boolean hasImages = false;
            for (COSName name : page.getResources().getXObjectNames()) {
                try {
                    if (!(page.getResources().getXObject(name) instanceof PDImageXObject)) continue;
                    hasImages = true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!hasImages) continue;
            result.add(i + 1);
        }
        return result;
    }
}

